
-- ABKs aus ASK aktualisieren
-- SELECT tsystem.function__drop_by_regex('refresh_abkabg', _commit => true);

CREATE OR REPLACE FUNCTION tplanterm.refresh_abkabg(
    IN _askix integer,
    IN _terminierte_abk boolean DEFAULT false,
    IN _add_ag_simple boolean DEFAULT false
       -- Arbeitsgangtext und Arbeitsplatz aktualisieren: aktuell, wenn beide anderen nicht gesetzt sind
    -- IN _agtxt_workplace__ksap boolean DEFAULT true
    )
    RETURNS void
    AS $$
    DECLARE _r record;
            _msg varchar;
            _setting_chkterminpast boolean;
    BEGIN
       IF NOT _terminierte_abk THEN -- wenn terminierte ABKs nicht mit umgeschrieben werden sollen
            IF EXISTS(SELECT true FROM abk
                       WHERE ab_askix = _askix
                         AND NOT ab_done
                         AND NOT ab_buch
                         AND NOT ab_rckmeld
                         AND coalesce(ab_at, ab_et) IS NOT NULL
                      )
            THEN -- aber terminierte ABKs existieren, dann Hinweis an Benutzer
                PERFORM PRODAT_TEXT(16542);
            END IF;
       END IF;

       -- einfaches Hinzufügen der fehlenden AG aus ASK (ohne Neuerstellung der AG, ohne Neuterminierung)
       IF _add_ag_simple THEN

            -- In AVOR entfernte Arbeitsgänge aus ABK entfernen => alles nicht so einfach:
             -- manuell eingefügte AGs nicht zu unterscheiden. a2_id_id wird null, wenn AG in AVOR gelöscht wird
            /*
            DELETE FROM ab2
             WHERE ab_askix = _askix
                   -- manuell eingefügte AG erhalten!
               AND a2_o2_id IS NOT NULL

               AND a2_o2_id NOT IN (SELECT o2_id FROM op2 WHERE o2_ix = _askix)
                   -- nur laufende / unberührte
               AND NOT a2_ende
               AND NOT a2_rckmeld
               AND NOT a2_buch
               AND     a2_time_stemp = 0
            ;
            */

            FOR _r IN SELECT ab_ix, o2_n
                        FROM op2
                        JOIN abk ON         ab_askix = o2_ix
                                    AND NOT ab_done
                                    AND NOT ab_buch
                                    AND NOT ab_rckmeld -- diese offenen ABK
                       WHERE o2_ix = _askix -- dieser ASK
                         AND NOT EXISTS(SELECT true FROM ab2 WHERE a2_ab_ix = ab_ix AND a2_o2_id = o2_id) -- An dieser ABK existiert der AG aus AVOR nicht.
                       ORDER BY ab_ix, o2_n
            LOOP
                BEGIN
                    -- Alle AG-Nr. entspr. AVOR umschreiben, damit neuer AG Platz bekommt. Händisch angelegt AG können nicht bewertet werden und stehen ggf. in Konflikt.
                    UPDATE ab2
                       SET a2_n = -a2_n -- erst zurücksetzen, wegen UNIQUE ab2_ix_opn
                      FROM op2
                     WHERE a2_o2_id = o2_id
                       AND o2_ix = _askix -- sicherheitshalber nochmal auf ASK einschränken
                       AND a2_ab_ix = _r.ab_ix
                       AND a2_n <> o2_n; -- nur einmal im LOOP bei mehreren AG

                    UPDATE ab2
                       SET a2_n = o2_n -- neue AG-Nr.
                      FROM op2
                     WHERE a2_o2_id = o2_id
                       AND o2_ix = _askix -- sicherheitshalber nochmal auf ASK einschränken
                       AND a2_ab_ix = _r.ab_ix
                       AND a2_n <> o2_n; -- nur einmal im LOOP bei mehreren AG

                    PERFORM tabk.abk__ab2__from_op2__create(_r.ab_ix, _askix, false, NULL, _r.o2_n); -- fehlenden AG ergänzen.
                EXCEPTION WHEN OTHERS THEN -- Bei Fehlern nur ABK notieren und fortfahren
                    RAISE NOTICE '%', sqlerrm;
                    _msg := coalesce(_msg || ', ', '') || E'\n' || _r.ab_ix || ' -> ' || sqlerrm;
                END;
            END LOOP;
       -- komplette Neuerzeugung und ggf. Neuterminierung der AG
       ELSIF _terminierte_abk THEN
            -- alle offenen ABK (ggf. auch terminierte)
            FOR _r IN SELECT ab_ix, ab_et, coalesce(ab_at, ab_et) IS NOT NULL AS is_terminiert
                        FROM abk
                       WHERE ab_askix = _askix
                         AND NOT ab_done
                         AND NOT ab_buch
                         AND NOT ab_rckmeld
                         AND     (   coalesce(ab_at, ab_et) IS NULL
                                  OR _terminierte_abk
                                  )
                       ORDER BY ab_ix
            LOOP
                BEGIN
                    -- terminierte ABK Austerminieren, wenn diese mit umgeschrieben werden sollen
                    IF _terminierte_abk AND _r.is_terminiert THEN
                       PERFORM tplanterm.abk_austerm(_r.ab_ix);
                    END IF;

                    -- eigentliches Umschreiben der AG
                    DELETE FROM ab2 WHERE a2_ab_ix = _r.ab_ix; -- alte AG löschen
                    PERFORM tabk.abk__ab2__from_op2__create(_r.ab_ix, _askix); -- AG aus aktueller ASK neu erstellen.

                    -- terminierte ABK wieder Einterminieren (rückwärts)
                    IF _terminierte_abk AND _r.is_terminiert THEN
                       _setting_chkterminpast := TSystem.Settings__GetBool('ChkTerminiBreakDateInPast');
                       PERFORM TSystem.Settings__Set('ChkTerminiBreakDateInPast', false) WHERE _setting_chkterminpast; -- Setting ggf. abschalten 'Rückwärtsterminieren abbrechen, wenn Datum in der Vergangenheit'
                       PERFORM tplanterm.abk_term(_r.ab_ix, _r.ab_et, false); -- Rückwärtsterminierung
                       PERFORM TSystem.Settings__Set('ChkTerminiBreakDateInPast', true) WHERE _setting_chkterminpast; -- Setting ggf. wieder aktivieren
                    END IF;
                EXCEPTION WHEN OTHERS THEN -- Bei Fehlern nur ABK notieren und fortfahren
                    RAISE NOTICE '%', sqlerrm;
                    _msg := coalesce(_msg || ', ', '') || E'\n' || _r.ab_ix || ' -> ' || sqlerrm;
                END;
            END LOOP;
       -- nur Übertragen von Arbeitsplatz und Arbeitsgangtext
       ELSE
            UPDATE ab2
               SET a2_txt = o2_txt,
                   a2_txt_rtf = o2_txt_rtf,
                   a2_ks  = o2_ks,
                   a2_ksap = o2_ksap
              FROM op2
             WHERE o2_ix = _askix
               AND a2_o2_id = o2_id
               AND NOT a2_ende;

       END IF;

       IF _msg IS NOT NULL THEN -- fehlgeschlagene ABKs ausgeben
          IF _add_ag_simple THEN
             _msg := lang_text(16662) || E'\n\n' || _msg;
          ELSE
             _msg := lang_text(16545) || E'\n\n' || _msg;
          END IF;
          PERFORM PRODAT_TEXT(_msg);
          RAISE NOTICE '%', _msg;
       END IF;

       RETURN;
    END $$ LANGUAGE plpgsql;
--

/*PLANUNG UND TERMINIERUNG*/

--
CREATE OR REPLACE FUNCTION tplanterm.deleteabk(abix INTEGER) RETURNS VOID AS $$
  DECLARE r RECORD;
            ldid INTEGER;
            agid INTEGER;
  BEGIN
     --
     PERFORM execution_code__disable( _flagname => 'bedarfberech' );
     --wir setzen die Bestellungen mit Dokument die für diese ABK erstellt wurde zurück! Eine Bestellung mit Dokument darf nicht einfach gelöscht werden!
     -- UPDATE ldsdok SET ld_ag_id=NULL, ld_abk=NULL WHERE ld_ag_id IN (SELECT * FROM tplanterm.get_all_parent_auftg(abix)) AND ld_code='E' AND ld_dokunr IS NOT NULL;
     UPDATE ldsdok SET ld_ag_id=NULL, ld_abk=NULL WHERE ld_ag_id IN (SELECT ag_id FROM auftg WHERE ag_parentabk = abix) AND ld_code='E' AND ld_dokunr IS NOT NULL;
     --
     DELETE FROM abk WHERE ab_ix=abix;

     /*
     FOR r IN SELECT * FROM tplanterm.get_all_parent_abk(abix) ORDER BY 1 DESC LOOP
            BEGIN
                    RAISE NOTICE 'TPlanterm.DeleteAbk(%), Try to delete ParentABK %', abix, r.get_all_parent_abk;

                  --  SELECT ld_id INTO ldid FROM ldsdok WHERE ld_abk=r.get_all_parent_abk;
                    --dadurch wird ld_abk gelöscht, daher drüber die Verknüpfung merken
                    DELETE FROM abk WHERE ab_ix=r.get_all_parent_abk;
                    --löschen von internen Bestellungen, welche die ABK verursacht hat. Gleichzeitig merken, welcher interne Auftrag der Verursacher ist, damit dieser ebenfalls gelöscht werden kann
                  --  DELETE FROM ldsdok WHERE ld_id=ldid AND ld_interncreate RETURNING ld_ag_id INTO agid;
                    --löschen des vorhergehenden Bedarfsverursachers (interner Auftrag)
                  --  DELETE FROM auftg WHERE ag_id=agid AND ag_astat='I';
                    --löschen von allen Bedarfen die keine eigene ABK sind
                  --  DELETE FROM auftg WHERE ag_parentabk=r.get_all_parent_abk AND ag_ownabk IS NULL;-- AND NOT EXISTS (SELECT true FROM ldsdok WHERE ld_ag_id=ag_id);
                    --DELETE FROM auftg WHERE ag_mainabk=r.get_all_parent_abk AND NOT EXISTS (SELECT true FROM ldsdok WHERE ld_ag_id=ag_id);
            EXCEPTION
                    WHEN OTHERS THEN BEGIN
                            PERFORM PRODAT_ERROR('Error deleting ABK:'||r.get_all_parent_abk||E'\n'||SQLERRM);
                    END;
            END;
     END LOOP;
     --*/

     PERFORM execution_code__enable( _flagname => 'bedarfberech' );
     PERFORM do_artikel_bedarf();
     --
     RETURN;
  END $$ LANGUAGE plpgsql;
--


/*Einlasten von Kapazität auf einer Kostenstelle*/

-- Haupfunktion für Datumsfolge inklusive Starttag (von, bis, ohne Wochenenden, ohne Feiertage, ohne Betriebsurlaub)
-- Betriebsurlaub ist abhängig von substFT, DEFAULT TRUE da es bis zur Einführung nicht berücksichtigt wurde
CREATE OR REPLACE FUNCTION tplanterm.makedateline(startDay DATE, endDay DATE, substWE BOOLEAN DEFAULT FALSE, substFT BOOLEAN DEFAULT FALSE, substBU BOOLEAN DEFAULT TRUE) RETURNS SETOF DATE AS $$
 DECLARE datesRec RECORD;
 BEGIN
    FOR datesRec IN SELECT generate_series::DATE AS dat, ft_id IS NOT NULL AS isFT, ft_urlaub AS isBT
                    FROM GENERATE_SERIES(startDay, endDay, '1 day')
                    LEFT JOIN feiertag ON ft_date=generate_series::DATE
    LOOP
        IF substWE THEN -- Wochende auschließen
            IF EXTRACT(DOW FROM datesRec.dat) IN (0, 6) THEN
                CONTINUE;
            END IF;
        END IF;
        IF substFT AND datesRec.isFT THEN -- Feiertage ausschließen und Feiertag vorhanden
            IF datesRec.isBT THEN        -- Betriebsurlaub
                IF substBU THEN -- Betriebsurlaub ausschließen
                    CONTINUE;
                END IF;
            ELSE                -- kein Betriebsurlaub
                CONTINUE;
            END IF;
        END IF;

        RETURN NEXT datesRec.dat;
    END LOOP;
    RETURN;
 END $$ LANGUAGE plpgsql STABLE STRICT;
--

-- Datumsfolge von heute bis angg. Datum
CREATE OR REPLACE FUNCTION tplanterm.makedateline(endDate DATE, substWE BOOLEAN DEFAULT FALSE, substFT BOOLEAN DEFAULT FALSE, substBU BOOLEAN DEFAULT TRUE) RETURNS SETOF DATE AS $$
 DECLARE d date;
 BEGIN
    FOR d IN SELECT makedateline FROM tplanterm.makedateline(current_date, endDate, substWE, substFT, substBU) LOOP
        RETURN NEXT d;
    END LOOP;
    RETURN;
 END $$ LANGUAGE plpgsql STABLE STRICT;
--

-- Datumsfolge vom Startdatum inkluse x Tage lang (01.07.2007, 7 => 1.7. bis 7.7.)
CREATE OR REPLACE FUNCTION tplanterm.makedateline(startDay DATE, nrDays INTEGER, substWE BOOLEAN DEFAULT FALSE, substFT BOOLEAN DEFAULT FALSE, substBU BOOLEAN DEFAULT TRUE) RETURNS SETOF DATE AS $$
 DECLARE d DATE;
 BEGIN
    FOR d IN SELECT makedateline FROM tplanterm.makedateline(startDay, startDay+nrDays-1, substWE, substFT, substBU) LOOP
        RETURN NEXT d;
    END LOOP;
    RETURN;
 END $$ LANGUAGE plpgsql STABLE STRICT;
--

--Kapazität von heute bis zu einem gewissen Datum herausfinden

CREATE OR REPLACE FUNCTION tplanterm.ks_getkapatodate(IN ks VARCHAR, IN _d DATE) RETURNS ks_getkapatodate_type AS $$
  DECLARE k NUMERIC;
            kw NUMERIC;
            dayofweek INTEGER;
            ksvrecord RECORD;
            belastrecord RECORD;
            kapa NUMERIC;
            R ks_getkapatodate_type;
  BEGIN
     k:=0;
     kw:=0;
     SELECT * FROM ksv INTO ksvrecord WHERE ks_abt=ks;
     FOR belastrecord IN SELECT makedateline, bl_kapa/3600 AS blkap, bl_bl/3600 AS blbelast FROM bel RIGHT OUTER JOIN tplanterm.makedateline(_d) ON bl_date=makedateline AND bl_ks=ks LOOP
            --
            dayofweek:=day_of_week(belastrecord.makedateline);
            IF dayofweek=1 THEN kapa:=ksvrecord.ks_ka1;
             ELSIF dayofweek=2 THEN kapa:=ksvrecord.ks_ka2;
             ELSIF dayofweek=3 THEN kapa:=ksvrecord.ks_ka3;
             ELSIF dayofweek=4 THEN kapa:=ksvrecord.ks_ka4;
             ELSIF dayofweek=5 THEN kapa:=ksvrecord.ks_ka5;
             ELSIF dayofweek=6 THEN kapa:=ksvrecord.ks_ka6;
             ELSIF dayofweek=0 THEN kapa:=ksvrecord.ks_ka7;
            END IF;
            --
            k:=k+COALESCE(belastrecord.blkap, kapa, 0);
            kw:=kw+COALESCE(belastrecord.blbelast, 0);
     END LOOP;
     R.ks_kapa:=CAST(COALESCE(k, 0) AS NUMERIC(19,2));
     R.ks_belast:=CAST(COALESCE(kw, 0) AS NUMERIC(19,2));
     RETURN R;
  END $$ LANGUAGE plpgsql STABLE;


--
CREATE OR REPLACE FUNCTION tplanterm.get_all_parent_abk(INTEGER) RETURNS SETOF INTEGER AS $$
  DECLARE auftgrec RECORD;
          rec RECORD;
  BEGIN
    RETURN NEXT $1;
    FOR auftgrec IN SELECT ag_parentabk FROM auftg WHERE ag_ownabk=$1 LOOP
        IF auftgrec.ag_parentabk IS NOT NULL THEN
            RETURN NEXT auftgrec.ag_parentabk;
            --
            FOR rec IN SELECT DISTINCT get_all_parent_abk FROM tplanterm.get_all_parent_abk(auftgrec.ag_parentabk) LOOP
                RETURN NEXT rec.get_all_parent_abk;
            END LOOP;
        END IF;
    END LOOP;
    RETURN;
  END $$ LANGUAGE plpgsql STABLE STRICT;
--


--
-- Zum Auftrag die ABK suchen, wenn nicht direkt dann freien PA
-- Verwendung : Lieferliste, Assistent WaWi, Tab offene Aufträge
-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Auftg
SELECT tsystem.function__drop_by_regex( 'auftg_get_abk', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.auftg_get_abk(
        _agid integer,
        _fuzzy boolean DEFAULT TRUE,
        _plan boolean DEFAULT FALSE
        )
        RETURNS integer
        AS $$
        DECLARE _result integer;
                _aknr varchar;
                _vorbedarf numeric;
                _ld_abk_rec record;
        BEGIN
          -- Direkten Fertigungsauftrag bevorzugen (ld_abk FROM ld_ag_id)
          _result := ld_abk FROM ldsdok
                           WHERE ld_ag_id = _agid
                             AND ld_code = 'I'
                           ORDER BY ld_datum LIMIT 1;
          IF _result IS NOT null THEN  RETURN _result; END IF;

          -- direkten Fertigungsauftrag bevorzugen: Verknüpfung über ldsauftg (Automatisch oder manuell oder über Bestellvorschlag in Liste Verknüpfte Aufträge zugewiesen)
           -- https://redmine.prodat-sql.de/issues/13053
          _result := ld_abk FROM ldsdok
                            JOIN ldsauftg ON la_ld_id = ld_id
                           WHERE la_ag_id = _agid
                             AND ld_code = 'I'
                           ORDER BY ld_datum LIMIT 1;
          IF _result IS NOT null THEN RETURN _result; END IF;

          -- Fertigungsprojekt: direkte ABK bevorzugen
          -- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Auftg
          _result := ag_ownabk FROM auftg WHERE ag_id = _agid;
          IF _result IS NOT null THEN RETURN _result; END IF;
          -- Fertigungsprojekt: über Orga-Verknüpfung. Nur wenn Positionszuordnung auch passt!
          SELECT tplanterm.auftg_get_abk_orgastru(_agid) INTO _result ORDER BY 1 LIMIT 1;
          IF _result IS NOT null THEN RETURN _result; END IF;


          -- _Plan-ABK finden. Nur interessant, wenn nicht _fuzzy
          IF _result IS null AND NOT _fuzzy AND _plan THEN
              -- Handelt es sich um eine Baugruppe, wird auf Einplanung des Kopfartikels geprüft, da sonst mehrere Datensätze.
              _result := ab_ix FROM auftg
                               JOIN abk ON ag_id = ab_plan_ag_id
                              WHERE ag_id = _agid
                                AND ab_ap_nr = ag_aknr;
          END IF;

          SELECT ag_aknr INTO _aknr
            FROM auftg
           WHERE NOT ag_done
             AND ag_astat IN ('E', 'I', 'R')
             AND ag_pos > 0
             AND ag_id = _agid; -- Artikel aus Auftragspos.

          -- Die bestimmte Auftragsposition gibts nicht, ist Rahmen, Angebot oder schon geschlossen - dann keine große Zuordnungssuche starten.
          IF _aknr IS null THEN -- Kein Artikel (Projekt) => keine Möglichkeit _Fuzzy
              RETURN _result;
          END IF;

          IF _result IS null AND _fuzzy AND NOT _plan THEN
              -- Bedarf bis zum Auftrag
              SELECT gesamtbedarf - offen INTO _vorbedarf FROM (
                  SELECT ag_id, ag_stk_uf1 - ag_stkl AS offen,
                         SUM (ag_stk_uf1 - ag_stkl) OVER (ORDER BY coalesce(ag_aldatum, ag_ldatum, ag_kdatum), ag_nr, ag_pos) AS gesamtbedarf -- Summe nach Priorität
                    FROM auftg
                   WHERE NOT ag_done
                     AND ag_astat IN ('E', 'I') AND ag_pos > 0 -- keine Rahmen
                     AND ag_aknr = _aknr
                     AND NOT EXISTS(SELECT TRUE FROM ldsdok WHERE ld_ag_id = ag_id) -- keine direkte Fertigung damit verbunden
              ) AS sub
              WHERE ag_id = _agid;

              -- Alle Fertigungen zum Artikel nach Priorität durchlaufen und vom _Vorbedarf abziehen.
              FOR _ld_abk_rec IN
                 SELECT ld_abk, coalesce(ld_stk_soll_uf1, ld_stk_uf1) - coalesce(ag_stk_uf1, 0) AS uebermenge
                   FROM ldsdok
                   LEFT JOIN auftg ON ag_id = ld_ag_id -- Evtl. Kundenauftrag an interner Bestellung für Mengenvergleich
                  WHERE ld_code = 'I' AND NOT ld_done AND ld_abk IS NOT null
                    AND ld_aknr = _aknr -- Einschränkung auf passenden Artikel des Quellauftrags
                    AND (ld_ag_id IS null OR coalesce(ld_stk_soll_uf1, ld_stk_uf1) > ag_stk_uf1) -- ohne Auftrag oder Überproduktion
                  -- Priorität der Zuordnung
                  ORDER BY ld_auftg <> ag_nr, ld_terml, ld_auftg, ld_pos -- Sortierung nach Bool (falsch, 0 zuerst), also Bestellnummer=Auftragsnummer bevorzugen
              LOOP
                  _vorbedarf := coalesce(_vorbedarf, 0) - _ld_abk_rec.uebermenge;

                  IF _vorbedarf < 0 THEN -- Wenn der Vorbedarf unterschritten wird, können wir die Fertigungsmenge des Auftrags (teilweise oder komplett) bedienen.
                      RETURN _ld_abk_rec.ld_abk;
                  END IF;
              END LOOP;
          END IF;

          RETURN _result;
        END $$ LANGUAGE plpgsql STABLE STRICT PARALLEL SAFE;

--https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/ABK-Index+Strukturen
SELECT tsystem.function__drop_by_regex( 'auftg_get_abk_orgastru', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.auftg_get_abk_orgastru(_agid integer) RETURNS SETOF integer AS $$
    DECLARE _auftgtxt_dbrid varchar;
            _auftg_ag_ownabk varchar;
            _abks record;
    BEGIN
        SELECT auftgtxt.dbrid, ag_ownabk
          INTO _auftgtxt_dbrid, _auftg_ag_ownabk
          FROM auftg, auftgtxt
         WHERE ag_id = _agid
           AND at_astat = ag_astat
           AND at_nr = ag_nr;

        FOR _abks IN SELECT ab_ix
                       FROM abk
                      WHERE ab_tablename = 'auftgtxt'
                        AND abk.ab_dbrid = _auftgtxt_dbrid
                        AND ab_parentabk IS NULL
                        AND NOT ab_done
                        AND _auftg_ag_ownabk IS DISTINCT FROM ab_ix
                        AND _auftg_ag_ownabk NOT IN (SELECT ab_ix FROM abk a1 WHERE a1.ab_parentabk = abk.ab_ix) -- wenn ABK direkt verknüpft, ist es keine Org-ABK sind eine ABK aus Fertigung oder -Projekt
                                                                                                                 -- * Orga-Strukturen sind immer in Ebene 0, Konfliktfall offen: unter Org-Struktur befindet sich ab Stelle X ein Fertigungsprojekt
                      ORDER BY ab_ix
        LOOP
            RETURN NEXT _abks.ab_ix;
        END LOOP;

        RETURN;
    END $$ LANGUAGE plpgsql STABLE;

--https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/ABK-Index+Strukturen
SELECT tsystem.function__drop_by_regex( 'ldsdok_get_abk_orgastru', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.ldsdok_get_abk_orgastru(_ldid integer) RETURNS SETOF integer AS $$
    DECLARE _ldsdok_dbrid varchar;
            _ldsdok_ld_abk varchar;
            _abks record;
    BEGIN
        SELECT ldsdok.dbrid
          INTO _ldsdok_dbrid, _ldsdok_ld_abk
          FROM ldsdok
         WHERE ld_id = _ldid;

        FOR _abks IN SELECT ab_ix
                       FROM abk
                      WHERE ab_tablename = 'ldsdok'
                        AND abk.ab_dbrid = _ldsdok_dbrid
                        AND ab_parentabk IS NULL
                        AND NOT ab_done
                        AND _ldsdok_ld_abk IS DISTINCT FROM ab_ix
                        AND _ldsdok_ld_abk NOT IN (SELECT ab_ix FROM abk a1 WHERE a1.ab_parentabk=abk.ab_ix) -- wenn ABK direkt verknüpft, ist es keine Org-ABK sind eine ABK aus Fertigung oder -Projekt
                                                                                                             -- * Orga-Strukturen sind immer in Ebene 0, Konfliktfall offen: unter Org-Struktur befindet sich ab Stelle X ein Fertigungsprojekt
                      ORDER BY ab_ix
        LOOP
            RETURN NEXT _abks.ab_ix;
        END LOOP;
        RETURN;
    END $$ LANGUAGE plpgsql STABLE;

--- #22280
CREATE OR REPLACE FUNCTION tplanterm.qab_get_abk_orgastru( _q_nr integer ) RETURNS SETOF integer AS $$
    DECLARE _qab_dbrid varchar;
            _abks record;
    BEGIN
        SELECT qab.dbrid
          INTO _qab_dbrid
          FROM qab
         WHERE q_nr = _q_nr;

        FOR _abks IN SELECT ab_ix
                       FROM abk
                      WHERE ab_tablename = 'qab'
                        AND abk.ab_dbrid = _qab_dbrid
                        AND ab_parentabk IS NULL
                        AND NOT ab_done
                      ORDER BY ab_ix
        LOOP
            RETURN NEXT _abks.ab_ix;
        END LOOP;
        RETURN;
    END $$ LANGUAGE plpgsql STABLE;
---
CREATE OR REPLACE FUNCTION tplanterm.wareneingangskontrolle_get_abk_orgastru( _wek_nr integer ) RETURNS SETOF integer AS $$
    DECLARE _wek_dbrid varchar;
            _abks record;
    BEGIN
        SELECT wareneingangskontrolle.dbrid
          INTO _wek_dbrid
          FROM wareneingangskontrolle
         WHERE wek_nr = _wek_nr;

        FOR _abks IN SELECT ab_ix
                       FROM abk
                      WHERE ab_tablename = 'wareneingangskontrolle'
                        AND abk.ab_dbrid = _wek_dbrid
                        AND ab_parentabk IS NULL
                        AND NOT ab_done
                      ORDER BY ab_ix
        LOOP
            RETURN NEXT _abks.ab_ix;
        END LOOP;
        RETURN;
    END $$ LANGUAGE plpgsql STABLE;
---

-->>CREATE OR REPLACE FUNCTION tabk.abk_auftg__setartikel_get_parent_fertigungsartikel
--
-->>CREATE OR REPLACE FUNCTION tabk.abk_auftg__setartikel_get_all_child_setabk
--
--Versucht zum Artikel den passenden freien Einkauf zu finden
--Verwendung: automatisches Zusammenordnen von Baugruppen in ABK, Nachkalkulation
SELECT tsystem.function__drop_by_regex( 'get_fertigungsauftrag', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.get_fertigungsauftrag(IN _aknr varchar, _done_ldsdok boolean DEFAULT FALSE, _auftgnr varchar DEFAULT NULL, _beddat date DEFAULT current_date) RETURNS integer
    AS $$
        SELECT ld_abk
          FROM ldsdok
         WHERE ld_code = 'I'
           AND ld_aknr = _aknr
           AND ld_stk_uf1 >= coalesce((SELECT sum(ag_stk_uf1) FROM auftg WHERE ag_ownabk = ld_abk),0)
           AND coalesce(ld_terml, ld_term, _beddat) >= _beddat + 30 - 365
         ORDER BY
               IFTHEN(_done_ldsdok, NOT ld_done, ld_done),
               IFTHEN(_auftgnr IS NULL, NULL, _auftgnr = ld_auftg) DESC,
               coalesce(ld_terml, ld_term) NULLS LAST
         LIMIT 1;
        --ORDER BY -> zuerst abgeschlossene ldsdok, zuerst laufende ldsdok (je nachdem ob vor- oder nachkalkulation verknüpft werden soll)
    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--

-- alle zusammenhängenden ABK
-- langsame plpgsql-Funktion wenn alle 4 Parameter angegeben sind
CREATE OR REPLACE FUNCTION tplanterm.get_all_child_abk(
      IN _abix           integer,
      IN _TryCompleteStv boolean,
      IN _OnlySetAbk     boolean,
      IN _OnlyByLifsch   boolean -- DEFAULT false
    )
    RETURNS SETOF integer
    AS $$
    DECLARE auftgrec  record;
            abkrec    record;
            abkindex  integer;
            abk_out   integer;
    BEGIN
        /*
            _TryCompleteStv   : versuchen Passende ABK (freien Produktionsauftrag) zu finden
            _OnlySetAbk       : Für Set-Artikel: nur soweit nach unten gehen, bis die nächste richtige ABK (mit Produktionsauftrag=Bestellung intern) gefunden wird.
                               http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Set-Artikel
                               ab_ld_id IS NULL
            _OnlyByLifsch     : (3 wertig) true: gebuchte Vorprodukte nur anhand lifsch ermitteln. Komplette Rückführung ausschließen. (Ist)     Verwendung im Materialnachweis
                               false: nicht anhand Buchungen (lifsch), also nur per Materialbedarf (auftg, abk). (Soll)                         Verwendung bei Lagerabgang ABK-bezogen
                               NULL: inklusive Buchungen (lifsch), also zusätzlich zum Materialbedarf. (Soll/Ist)                              Verwendung könnte für Nachkalkulation sein.
        */

        IF _abix IS NULL THEN -- Funktion ist kein STRICT mehr, weil _OnlyByLifsch NULL sein darf.
            RETURN;
        END IF;

        RETURN NEXT _abix;

        -- auf Basis von Material-/Unterbauteilbedarfe (interne Aufträge) auflösen
        IF     NOT _OnlySetAbk
           AND     coalesce(NOT _OnlyByLifsch, true) -- siehe Doku oben: (3 wertig)
        THEN
            FOR auftgrec IN SELECT DISTINCT ag_ownabk, ag_aknr
                              FROM auftg JOIN art ON ak_nr = ag_aknr
                             WHERE ag_parentabk = _abix
                               AND ak_fertigung
                             ORDER BY 1
            LOOP
                abkindex:= auftgrec.ag_ownabk;
                IF abkindex IS NULL AND _TryCompleteSTV THEN -- Versuchen eine passende ABK zu finden.
                        abkindex:= tplanterm.get_fertigungsauftrag(auftgrec.ag_aknr);
                END IF;
                IF abkindex IS NOT NULL THEN
                    IF abkindex = _abix THEN -- ABK soll sich nicht selbst auflösen. Ausgabe s.o.. Mgl. Fehler in Daten abfangen (ag_parentabk = ag_ownabk).
                        CONTINUE;
                    END IF;
                    -- RETURN NEXT abkindex; -- (DG) Doppelte Ausgabe verhindern. Funktion beginnt mit RETURN NEXT _abix; - Aufruf im LOOP reicht. Vgl. #7784
                    FOR abk_out IN SELECT DISTINCT get_all_child_abk FROM tplanterm.get_all_child_abk(abkindex, _TryCompleteStv, _OnlySetAbk, _OnlyByLifsch) LOOP
                        RETURN NEXT abk_out;
                    END LOOP;
                END IF;
            END LOOP;
        END IF;

        -- auf Basis von ABK auflösen
        IF coalesce(NOT _OnlyByLifsch, true) THEN -- siehe Doku oben: (3 wertig)
            FOR abkrec IN SELECT DISTINCT ab_ix, ab_ld_id
                            FROM abk
                           WHERE ab_parentabk = _abix
                           ORDER BY 1
            LOOP -- alle Childs suchen
                IF (_OnlySetAbk AND abkrec.ab_ld_id IS NULL) OR NOT _OnlySetABK THEN -- Wenn wir nur Set-ABK wollen, dann auch nur ein Ergebnis rausgeben, wenn ab_ld_id NULL Ansonsten immer
                    IF abkrec.ab_ix = _abix THEN -- ABK soll sich nicht selbst auflösen. Ausgabe s.o.. Mgl. Fehler in Daten abfangen (ag_parentabk = ag_ownabk).
                        CONTINUE;
                    END IF;
                    -- RETURN NEXT abkrec.ab_ix; -- (DG) Doppelte Ausgabe verhindern. Funktion beginnt mit RETURN NEXT _abix; - Aufruf im LOOP reicht. Vgl. #7784
                    FOR abk_out IN SELECT DISTINCT get_all_child_abk FROM tplanterm.get_all_child_abk(abkrec.ab_ix, _TryCompleteStv, _OnlySetAbk, _OnlyByLifsch) LOOP
                        RETURN NEXT abk_out;
                    END LOOP;
                END IF;
            END LOOP;
        END IF;

        -- auf Basis von Buchungen, s.o.
        -- ohne Berücksichtigung der Option _TryCompleteSTV (müsste in dem Fall als UNION in auftgrec rein). Sowieso müsste alles per UNION ... WHERE Option gemacht werden, sonst Dopplungen und keine Kombination der Optionen möglich
        IF coalesce(_OnlyByLifsch, true) THEN
            FOR abkindex IN
                SELECT DISTINCT coalesce(ld_abk, ag_ownabk)
                  FROM lifsch
                  LEFT JOIN ldsdok ON ld_id = l_ld_id AND ld_abk IS NOT NULL -- Lagermenge kommt aus Bestellung mit ABK. Dann gehen wir von dieser ABK weiter, da auch das Material dieses Artikels eingegangen ist
                  LEFT JOIN auftg ON     ld_id IS NULL -- nur wenn keine ABK über Buchung gefunden wurde. l_ag_id IS NULL ist nicht zielführend bei Buchungen von Vorprodukten (mit ABK) auf ergänzte Materialpositionen (ohne ABK).
                                     AND ag_id = l_ag_id AND ag_ownabk IS NOT NULL -- Lagermengen auf Materialbedarf mit ABK.
                  LEFT JOIN LATERAL (SELECT SUM(w_zugang_uf1) AS sum_rckbuch FROM wendat WHERE w_l_nr = l_nr) AS rck ON coalesce(ld_abk, ag_ownabk) IS NOT NULL -- gesamte Rückführungsmenge. Nur berechnen, wenn ABK gefunden.
                 WHERE l_ab_ix = _abix -- für diese ABK gebuchtes Vorprodukt
                   AND EXISTS(SELECT true FROM abk WHERE ab_ix = coalesce(ld_abk, ag_ownabk)) -- Prüfung aufgrund fehlender Referenz (siehe JOIN auftg) und ld_abk = -1 (siehe ldsdok)
                   AND (l_abgg_uf1 - coalesce(sum_rckbuch, 0) > 0) -- Menge ist nicht komplett zurückgeführt. Mindermengen mit ABK sind nicht berücksichtigt (falls es sowas gibt).
                   AND NOT (_OnlyByLifsch IS NULL AND ag_ownabk IS NOT NULL) -- Wenn _OnlyByLifsch IS NULL (s.o.), dann auftg ausschließen (kommt von oben)
                UNION
                -- wenn ein Zwischenprodukt ungebucht ist (oder zB weil STR Artikel nie gebucht wird), kann es dennoch gebuchte Unterartikel enthalten
                SELECT ab_ix
                  FROM abk
                 WHERE ab_parentabk = _abix
                   -- AND TSystem.ENUM_GetValue(ag_stat, 'STR')

                 ORDER BY 1
            LOOP
                IF abkindex = _abix THEN -- ABK soll sich nicht selbst auflösen. Ausgabe s.o.. Mgl. Fehler in Daten abfangen (ag_parentabk = ag_ownabk).
                    CONTINUE;
                END IF;
                -- RETURN NEXT abkindex; -- (DG) Doppelte Ausgabe verhindern. Funktion beginnt mit RETURN NEXT _abix; - Aufruf im LOOP reicht. Vgl. #7784

                FOR abk_out IN SELECT DISTINCT get_all_child_abk FROM tplanterm.get_all_child_abk(abkindex, _TryCompleteStv, _OnlySetAbk, _OnlyByLifsch)
                LOOP
                    RETURN NEXT abk_out;
                END LOOP;
            END LOOP;
        END IF;
        --
        RETURN;
    END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE STRICT;

-- alle zusammenhängenden ABK
-- schnelle sql-Funktion wenn bis zu 3 Parameter angegeben sind
CREATE OR REPLACE FUNCTION tplanterm.get_all_child_abk(
    IN _abix           integer,               -- Start-ABK
    IN _TryCompleteStv boolean DEFAULT false, -- zu Fertigungsartikeln ohne Own-ABK versuchen passende ABK (freien Produktionsauftrag) zu finden
    IN _OnlySetAbk     boolean DEFAULT false  -- Für Set-Artikel: nur soweit nach unten gehen, bis die nächste richtige ABK (mit Produktionsauftrag=Bestellung intern) gefunden wird.
    -- ToDo: funktion auch für Parameter _OnlyByLifsch erweitern
    -- IN _OnlyByLifsch   boolean DEFAULT false
    )
    RETURNS SETOF integer
    AS $$

      WITH RECURSIVE
        --_const AS (SELECT _TryCompleteStv AS _TryCompleteStv__const),
        _const (_TryCompleteStv__const) AS ( values (_TryCompleteStv) ),

        _tree AS (

            -- aktuelle ABK als Start
            SELECT array_remove( ARRAY[abk.ab_ix], NULL ) AS child_abk   -- Start-ABK als child ABK mit Ebene 0 damit
                 , '{}'::int[]                            AS current_abk -- ABKs über der Start-ABK spielen keine Rolle
                 , 0                     AS depth
                 ,_TryCompleteStv__const
              FROM abk, _const
             WHERE abk.ab_ix = _abix

            UNION

            -- rekursiv Material-/Unterbauteilbedarfe und auf Basis von ABK auflösen (und evt. Fuzzy)
            SELECT array_remove(array[a.ag_ownabk, b.ab_ix, get_fertigungsauftrag], NULL) AS child_abk
                 , array_remove(array[a.ag_parentabk, b.ab_parentabk], NULL)              AS current_abk
                 , p.depth + 1
                 , _TryCompleteStv__const
              FROM _tree p

              -- Suche Own-ABKs der Materialien die zur ABK gehören. Verzweigung über Materialliste und dort angegebene VerbrauchsABK
              LEFT JOIN auftg a  ON a.ag_parentabk = ANY (p.child_abk) AND a.ag_ownabk  IS NOT null AND _OnlySetAbk IS false

              -- Fuzzy: alle Materiallisten, welche keinen direkten Bezug haben
              LEFT JOIN LATERAL (SELECT CASE WHEN _TryCompleteStv__const IS true THEN
                                            (SELECT array_Agg(ag_aknr )
                                               FROM auftg af JOIN art ON ak_nr = af.ag_aknr AND ak_fertigung
                                              WHERE af.ag_ownabk IS null
                                                AND af.ag_parentabk = ANY (p.child_abk)
                                            )
                                        ELSE
                                            null::varchar[]
                                        END::varchar[] AS ag_aknr
                                )
                                AS af ON _TryCompleteStv__const IS true AND _OnlySetAbk IS false

              -- Option _TryCompleteSTV:
              --- Suche freie ABKs wenn Materialien keine Own-ABK haben
              LEFT JOIN LATERAL (SELECT tplanterm.get_fertigungsauftrag(unnest) FROM unnest(af.ag_aknr) WHERE ag_ownabk IS NULL AND _TryCompleteStv) AS get_fertigungsauftrag ON _TryCompleteStv__const IS true AND _OnlySetAbk IS false
              -- Suche Child-ABKs anhand der ab_parentabk-Beziehung
              LEFT JOIN abk b ON b.ab_parentabk = ANY ( array_append( p.child_abk, get_fertigungsauftrag ) )
                             -- Option _OnlySetAbk: dann muss ab_ld_id leer sein
                             AND (    ( _OnlySetAbk AND b.ab_ld_id IS NULL )
                                   OR NOT _OnlySetABK
                                 )

             WHERE p.child_abk <> '{}' -- Wenn keine Child-ABK mehr gefunden wurden -> Ende des Zweigs erreicht
               AND p.depth < 50        -- Abbruchbedingung: maximale Tiefe von 50
        )

        SELECT DISTINCT ON ( unnest( child_abk ), depth )
            unnest( child_abk )
        FROM
            _tree
        ORDER BY depth DESC;

    $$ LANGUAGE sql STABLE PARALLEL SAFE STRICT;

CREATE OR REPLACE FUNCTION tplanterm.get_all_child_abk__array(
    IN _abix           integer,               -- Start-ABK
    IN _TryCompleteStv boolean DEFAULT false, -- zu Fertigungsartikeln ohne Own-ABK versuchen passende ABK (freien Produktionsauftrag) zu finden
    IN _OnlySetAbk     boolean DEFAULT false  -- Für Set-Artikel: nur soweit nach unten gehen, bis die nächste richtige ABK (mit Produktionsauftrag=Bestellung intern) gefunden wird.
    -- ToDo: funktion auch für Parameter _OnlyByLifsch erweitern
    -- IN _OnlyByLifsch   boolean DEFAULT false
    )
    RETURNS integer[]
    AS $$
      SELECT array_agg(get_all_child_abk) FROM tplanterm.get_all_child_abk(_abix, _TryCompleteStv, _OnlySetAbk);
    $$ LANGUAGE sql STABLE PARALLEL SAFE STRICT;


--
-- Findet Hauptauftrag (Kundenauftrag) bzw. übergeordneten Auftrag zu einer ABK.
-- Fuzzy-Suche findet passenden offenen Auftrag zum Artikel entspr. Termin.
CREATE OR REPLACE FUNCTION tplanterm.abk_main_auftg_id__extended(
    IN _abk     abk,
    IN _fuzzy   boolean = false,

    OUT agid    integer,
    -- Rückgabe ag_id ist fuzzy und keine klare Verknüpfung. Wird in Planung genutzt um zu entscheiden, ob der Produktionstermin "hart am Auftrag" ist, oder der Werkstatttermin eher führend ist
    -- Bsp: Rahmen mit bisher keinem Abruf. Intern werden schon 3 PA aufgelegt.
    -- Diese hätten alle den Ausliefertermin des nächsten offenen Abruf, wenn diese nicht fest verknüfpt sind. Für die Terminierung macht dann der vergebene (geplante) Werkstatttermin mehr sinn (ld_term)
    OUT is_fuzzy boolean
    )
    RETURNS record
    AS $$
    DECLARE
        _ld_id    integer;
        _main_abk integer;
        _record   record;
    BEGIN

      -- _main_abk := tabk.abk_main_abk( _abix ); -- TODO Prüfung. Ist ab_mainabk verlässlich?
      _main_abk := _abk.ab_mainabk; -- abk__b_10_iu__parentabk() RETURNS TRIGGER > ab_mainabk ist immer zuverlässig gesetzt

      is_fuzzy := false;
      agid    := ag_id FROM auftg WHERE ag_ownabk = _main_abk ORDER BY ag_id DESC LIMIT 1;


      -- Über ldsdok suchen
      IF agid IS NULL THEN
          IF (SELECT TSystem.ENUM_GetValue(ab_stat, 'F-ABK') FROM abk WHERE ab_ix = _main_abk) THEN
            --FolgeABK
            SELECT best.ld_ag_id, best.ld_id
             INTO agid, _ld_id
             FROM ldsdok AS best
             LEFT JOIN abk ON ((ab_dbrid = best.dbrid) AND TSystem.ENUM_GetValue(ab_stat, 'F-ABK'))
             LEFT JOIN ldsdok AS pa ON ((pa.ld_abk = ab_ix) AND (pa.ld_code = 'I') AND TSystem.ENUM_GetValue(pa.ld_stat, 'F-ABK'))
            WHERE (best.ld_code = 'E')
              AND (pa.ld_abk = _main_abk)
              AND TSystem.ENUM_GetValue(best.ld_stat, 'F-ABK');
          ELSE
            --Reguläre Bestellung
            SELECT ld_ag_id, ld_id
              INTO agid, _ld_id
              FROM ldsdok
             WHERE ld_abk = _main_abk;
          END IF;
      END IF;


      -- Fertigungsprojekt : über Materialliste
      IF agid IS NULL THEN

          -- Fertigungsprojekt unter Auftragsstruktur
          SELECT ag_astat, ag_id, ag_parentabk
            INTO _record
            FROM auftg
           WHERE ag_ownabk = _abk.ab_ix
           ORDER BY ag_id DESC
           LIMIT 1;

          agid := _record.ag_id;

        --wir stehen zB jetzt auf der internen Position, so lange nach oben gehen wie möglich
          IF _record.ag_astat = 'I' THEN

              -- unter Fertigungsprojekt eine interne Materiallistenposition einer Folgestückliste
              LOOP
                  SELECT ag_astat, ag_id, ag_parentabk
                     INTO _record
                     FROM auftg
                          -- erste Ebene geprüft
                    WHERE ag_ownabk = _record.ag_parentabk;

                  EXIT WHEN _record.ag_id IS NULL;

                   agid := _record.ag_id;

            END LOOP;

        END IF;

      END IF;

      -- Unscharfe Suche nur, wenn kein Auftrag gefunden und explizit per Funktionsaufruf gewollt ist.
      IF _fuzzy AND agid IS NULL THEN

         SELECT c_resultn
           INTO agid
           FROM tcache.function_cache
          WHERE c_funcname = 'abk_main_auftg_id__extended__fuzzysearch__by__aknr'
            AND c_param0 = _abk.ab_ap_nr
            AND NOT c_dirty;

         IF NOT FOUND THEN
            -- todo: ändern auf ldsauft join? klärung: 1:1, 1:n (ein Auftrag in mehreren Bestellungen aufgeteilt, zB Rahmenauftrag in viele einzelne PA's)
            agid := ag_id
            FROM auftg,
                 ldsdok
           WHERE ld_id = _ld_id
             AND ag_aknr = ld_aknr
             AND NOT ag_done
             AND ag_astat = 'E'
             AND ag_stkb = 0
           ORDER BY
                 NOT coalesce(ag_ldatum, ag_kdatum) > ld_terml,
                     coalesce(ag_ldatum, ag_kdatum)
           LIMIT 1
           ;

           PERFORM tcache.function_cache_setcache_1param('abk_main_auftg_id__extended__fuzzysearch__by__aknr', _abk.ab_ap_nr, resultn => agid);
         END IF;

         is_fuzzy := agid IS NOT NULL;

     END IF;

      -- Fertigungsprojekt
      IF agid IS NULL THEN

          -- wenn die ABK unter einem Auftrag als Projekt angelegt wurde....
          IF _abk.ab_tablename = 'auftgtxt' THEN

             agid := ag_id
                FROM auftg
                JOIN auftgtxt ON
                         at_astat = ag_astat
                     AND at_nr = ag_nr
               WHERE auftgtxt.dbrid = _abk.ab_dbrid
               ORDER BY
                     NOT ag_done DESC,
                         ag_pos
               LIMIT 1
             ;

             -- is project := true evtl zu ergänzen (kein fuzzy UND keine harte verknüpfung, da evtl Projektstruktur)
        END IF;
     END IF;

     RETURN;

    END $$ LANGUAGE plpgsql STABLE STRICT; -- PARALLEL SAFE; NOPE WEGEN UPDATE DARIN!


CREATE OR REPLACE FUNCTION tplanterm.abk_main_auftg_id__extended(
    IN _abix    integer,
    IN _fuzzy   boolean = false,

    OUT agid    integer,
    -- Rückgabe ag_id ist fuzzy und keine klare Verknüpfung. Wird in Planung genutzt um zu entscheiden, ob der Produktionstermin "hart am Auftrag" ist, oder der Werkstatttermin eher führend ist
    -- Bsp: Rahmen mit bisher keinem Abruf. Intern werden schon 3 PA aufgelegt.
    -- Diese hätten alle den Ausliefertermin des nächsten offenen Abruf, wenn diese nicht fest verknüfpt sind. Für die Terminierung macht dann der vergebene (geplante) Werkstatttermin mehr sinn (ld_term)
    OUT is_fuzzy boolean
    )
    RETURNS record
    AS $$
        SELECT (tplanterm.abk_main_auftg_id__extended(abk, _fuzzy)).* FROM abk WHERE ab_ix = _abix
    $$ LANGUAGE sql STABLE STRICT; -- PARALLEL SAFE; NOPE WEGEN UPDATE DARIN!


CREATE OR REPLACE FUNCTION tplanterm.abk_main_auftg(
          abix integer,
          fuzzy boolean DEFAULT FALSE
  )
  RETURNS auftg
  AS $$
     SELECT * FROM auftg WHERE ag_id = (tplanterm.abk_main_auftg_id__extended(abix, fuzzy)).agid;
  $$ LANGUAGE sql STABLE STRICT; -- PARALLEL SAFE; NOPE WEGEN UPDATE DARIN!
  -- ,(auftge).ag_nr
  -- LEFT JOIN LATERAL (SELECT (tplanterm.abk_main_auftg(a2_ab_ix)).*) AS auftge ON true

CREATE OR REPLACE FUNCTION tplanterm.abk_main_auftg_id(
          abix integer,
          fuzzy boolean DEFAULT FALSE
  )
  RETURNS integer
  AS $$
     SELECT (tplanterm.abk_main_auftg_id__extended(abix, fuzzy)).agid;
  $$ LANGUAGE sql STABLE STRICT; -- PARALLEL SAFE; NOPE WEGEN UPDATE DARIN!
--
CREATE OR REPLACE FUNCTION tplanterm.get_all_parent_auftg(INTEGER) RETURNS SETOF INTEGER AS $$
    DECLARE auftgrec RECORD;
            rec RECORD;
    BEGIN
     --RETURN NEXT ag_id FROM auftg WHERE ag_post6=$1;--falls das eine Baugruppe ist!
     FOR auftgrec IN SELECT ag_id, ag_parentabk FROM auftg WHERE ag_ownabk=$1 LOOP
            RETURN NEXT auftgrec.ag_id;
            FOR rec IN SELECT * FROM tplanterm.get_all_parent_auftg(auftgrec.ag_parentabk) LOOP
                    RETURN NEXT rec.get_all_parent_auftg;
            END LOOP;
     END LOOP;
     RETURN;
    END $$ LANGUAGE plpgsql STABLE STRICT PARALLEL SAFE;
--

--
CREATE OR REPLACE FUNCTION tplanterm.get_all_child_auftg(
      _ab_ix INTEGER
  ) RETURNS SETOF INTEGER AS $$
  DECLARE
      _auftgrec RECORD;
      _rec      RECORD;
  BEGIN
    -- Hole alle ag_ids von auftgi_der_Child-ABKs zu einer ABK
    FOR _auftgrec IN
        SELECT ag_id, ag_ownabk
        FROM auftg
        WHERE ag_parentabk = _ab_ix
    LOOP
        RETURN NEXT _auftgrec.ag_id;

        -- Eigene Unter-ABK vorhanden? Dann rekursiver Aufruf
        IF ( _auftgrec.ag_ownabk IS NOT NULL ) THEN
            FOR _rec IN
                SELECT *
                FROM tplanterm.get_all_child_auftg( _auftgrec.ag_ownabk )
            LOOP
                RETURN NEXT _rec.get_all_child_auftg;
            END LOOP;
        END IF;
    END LOOP;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE STRICT PARALLEL SAFE;
--

--
CREATE OR REPLACE FUNCTION tplanterm.get_all_bestellung_abk(IN ldauftg VARCHAR, IN ldpos INTEGER) RETURNS SETOF INTEGER AS $$
    DECLARE r RECORD;
            ix INTEGER;
    BEGIN
     --ABK-Index aus Bestellung holen
     SELECT ld_abk INTO ix FROM ldsdok WHERE ld_code='I' AND ld_auftg=ldauftg AND ld_pos=ldpos;
     RETURN NEXT ix;
     --zu dieser abk alle unterabk holen
     FOR r IN SELECT * FROM tplanterm.get_all_child_abk(ix) LOOP
            RETURN NEXT r.get_all_child_abk;
     END LOOP;
     RETURN;
    END $$ LANGUAGE plpgsql STRICT;
--
CREATE OR REPLACE FUNCTION tplanterm.auto_buch_offen_abk_lagzu(IN ix INTEGER, IN realbuch BOOLEAN, IN teilmengebuch BOOLEAN) RETURNS INTEGER AS $$
    DECLARE ldsrec RECORD;
            pmenge NUMERIC;
            tmengeist NUMERIC;
            tmengesoll NUMERIC;
            offen NUMERIC;
    BEGIN
     --errechnen wieviel noch offen ist von der Ausgangsmenge
     pmenge:=ld_stkl/ld_stk_uf1*100 FROM ldsdok WHERE ld_abk=ix;
     ----pmenge:=round(pmenge);
     --
     FOR ldsrec IN SELECT * FROM ldsdok WHERE ld_abk IN (SELECT * FROM tplanterm.get_all_child_abk(ix)) AND NOT ld_done AND ld_abk<>ix LOOP
            IF round(pmenge)=100 OR NOT teilmengebuch THEN
                    IF realbuch THEN
                            INSERT INTO wendat (w_aknr, w_lds_id, w_lgchnr, w_zug_mec, w_zugang) VALUES (ldsrec.ld_aknr, ldsrec.ld_id, lang_text(105)||'='||CAST(ix AS VARCHAR), tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(ldsrec.ld_aknr), ldsrec.ld_stk_uf1-ldsrec.ld_stkl);
                    ELSE
                            UPDATE ldsdok SET ld_stkl=ld_stk_uf1, ld_done=TRUE WHERE ld_id=ldsrec.ld_id;
                    END IF;
                    UPDATE ldsdok SET ld_done=TRUE WHERE ld_id=ldsrec.ld_id AND NOT ld_done;--100% verbuchen, alles auf ende setzen. ld_stkl wurde durch wendat gesetzt
            ELSE --teilmenge verbuchen
                    tmengeist:=ldsrec.ld_stkl;
                    tmengesoll:=Round(ldsrec.ld_stk_uf1*pmenge/100,2);--das sollte bei dieser Endproduktzahl an Unterteilen gebucht sein. (80% der Bedarfsmenge....)
                    offen:=Round(tmengesoll-tmengeist,2);
                    --RAISE EXCEPTION 'pmenge:%,tmengeist:%,tmengesoll:%,offen:%', pmenge, tmengeist, tmengesoll, offen;
                    --differenz zwischen ist und soll buchen, wenn positiv
                    IF realbuch THEN
                            IF offen>0 THEN
                                    INSERT INTO wendat (w_aknr, w_lds_id, w_lgchnr, w_zug_mec, w_zugang) VALUES (ldsrec.ld_aknr, ldsrec.ld_id, lang_text(105)||'='||CAST(ix AS VARCHAR), tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(ldsrec.ld_aknr), offen);
                            END IF;
                    ELSE
                            IF offen>0 THEN
                                    UPDATE ldsdok SET ld_stkl=ld_stkl+offen, ld_done=ld_stkl+offen>=ld_stk_uf1 WHERE ld_id=ldsrec.ld_id;
                            END IF;
                    END IF;
            END IF;
            UPDATE ldsdok SET ld_done=TRUE WHERE ld_id=ldsrec.ld_id AND ld_stk_uf1<=ld_stkl AND NOT ld_done;--wenn Menge erfüllt auch direkt abschliessen
     END LOOP;
     RETURN 0;
    END $$ LANGUAGE plpgsql STRICT;



--
CREATE OR REPLACE FUNCTION tplanterm.auto_buch_offen_abk_lagab(IN ix INTEGER, IN teileart VARCHAR, IN realbuch BOOLEAN, IN nichtminus BOOLEAN, IN teilmengebuch BOOLEAN) RETURNS INTEGER AS $$
  DECLARE auftgrec RECORD;
          lagrec   RECORD;
         offen    NUMERIC;
          buch     NUMERIC;
          pmenge NUMERIC;
          tmengeist NUMERIC;
          tmengesoll NUMERIC;
  BEGIN
    --errechnen wieviel noch offen ist von der Ausgangsmenge
    pmenge:=ld_stkl/ld_stk_uf1*100 FROM ldsdok WHERE ld_abk=ix;
    ----pmenge:=round(pmenge);
    --
    --RAISE EXCEPTION 'tart:%,pmenge:%,tmengeist:%,tmengesoll:%,offen:%', teileart, pmenge, tmengeist, tmengesoll, offen;
    --
    FOR auftgrec IN SELECT * FROM auftg WHERE ag_post3 IN (SELECT * FROM tplanterm.get_all_child_abk(ix)) AND NOT ag_done AND teileart LIKE '%'||ag_post2||'%' LOOP
        --
        IF round(pmenge)=100 OR NOT teilmengebuch THEN
                 offen:=auftgrec.ag_stk_uf1-auftgrec.ag_stkl-COALESCE(auftgrec.ag_nk_stkl,0);
        ELSE--teilmenge buchen
            tmengeist:=auftgrec.ag_stkl;
            tmengesoll:=Round(auftgrec.ag_stk_uf1*pmenge/100,2);--das sollte bei dieser Endproduktzahl an Unterteilen gebucht sein. (80% der Bedarfsmenge....)
            offen:=Round(tmengesoll-tmengeist,2);
        END IF;
         If offen<0 THEN
            offen:=0;
        END IF;
        --
        IF realbuch THEN
            FOR lagrec IN SELECT * FROM lag WHERE lg_aknr=auftgrec.ag_aknr AND lg_anztot>0 ORDER BY lg_anztot DESC LOOP--wir buchen von den Lagerorten wieder runter
                IF offen>0 THEN
                    IF lagrec.lg_anztot>offen THEN
                        buch:=offen;
                    ELSE
                        buch:=lagrec.lg_anztot;
                    END IF;
                    offen:=offen-buch;
                    INSERT INTO lifsch (l_krz, l_krzl, l_krzf, l_aknr, l_ag_id, l_lgort, l_lgchnr, l_abg_mec, l_abgg) VALUES ('#', '#', '#', auftgrec.ag_aknr, auftgrec.ag_id, lagrec.lg_ort, lagrec.lg_chnr, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(auftgrec.ag_aknr), buch);
                END IF;
            END LOOP;--alle Lagerorte ablaufen und Mengen abbuchen!!!!!
            IF (offen>0)AND NOT nichtminus THEN--wir buchen alles das was wir nicht buchen konnten auf minus!
                INSERT INTO lifsch (l_krz, l_krzl, l_krzf, l_aknr, l_ag_id, l_lgchnr, l_abg_mec, l_abgg, l_lgort) VALUES ('#', '#', '#', auftgrec.ag_aknr, auftgrec.ag_id, 'AUTOBUCH:ABK='||$1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(auftgrec.ag_aknr), offen, 'MINUS');
            END IF;
        ELSE
                 UPDATE auftg SET ag_nk_stkl=ag_stkl+COALESCE(ag_nk_stkl,0)+offen, ag_done=ag_stk_uf1<=ag_stkl+COALESCE(ag_nk_stkl,0)+offen WHERE ag_id=auftgrec.ag_id;
        END IF;
         UPDATE auftg SET ag_done=TRUE WHERE ag_id=auftgrec.ag_id AND ag_stkl+COALESCE(ag_nk_stkl,0)>=ag_stk_uf1;
    END LOOP;
    RETURN 0;
  END $$ LANGUAGE plpgsql STRICT;


--Lagerbewegungen automatisch
 CREATE OR REPLACE FUNCTION tplanterm.auto_folgt_lagbuch(IN abix INTEGER, IN prozmenge NUMERIC) RETURNS INTEGER AS $$
    DECLARE ldsrec RECORD;
        auftgrec RECORD;
        lagrec   RECORD;
        offen     NUMERIC;
        buch      NUMERIC;
    BEGIN
     FOR ldsrec IN SELECT ldsdok.* FROM ldsdok JOIN auftg ON ag_id=ld_ag_id WHERE ld_ag_id IN (SELECT * FROM tplanterm.get_all_child_auftg($1)) AND NOT ld_done AND ld_stk_uf1=ag_stk_uf1 AND ld_code='I' LOOP
        INSERT INTO wendat (w_aknr, w_lds_id, w_lgchnr, w_zug_mec, w_zugang) VALUES (ldsrec.ld_aknr, ldsrec.ld_id, 'ABK='||$1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(ldsrec.ld_aknr), ldsrec.ld_stk_uf1*$2);
        UPDATE ldsdok SET ld_done=TRUE WHERE ld_id=ldsrec.ld_id AND ld_stk_uf1<=ld_stkl;
     END LOOP;
     FOR auftgrec IN SELECT * FROM auftg WHERE ag_post3 IN (SELECT * FROM tplanterm.get_all_child_abk($1)) AND NOT ag_done AND COALESCE(ag_bstat, '')<>'M' LOOP--alle noch nicht händisch (Manuell) gebuchten Materialien!
         offen:=auftgrec.ag_stk_uf1*$2;
         FOR lagrec IN SELECT * FROM lag WHERE lg_aknr=auftgrec.ag_aknr AND lg_anztot>0 ORDER BY lg_anztot DESC LOOP--wir buchen von den Lagerorten wieder runter
            IF offen>0 THEN
                IF lagrec.lg_anztot>offen THEN
                    buch:=offen;
                ELSE
                    buch:=lagrec.lg_anztot;
                END IF;
                offen:=offen-buch;
                INSERT INTO lifsch (l_krz, l_krzl, l_krzf, l_aknr, l_ag_id, l_lgort, l_lgchnr, l_abg_mec, l_abgg) VALUES ('#', '#', '#', auftgrec.ag_aknr, auftgrec.ag_id, lagrec.lg_ort, lagrec.lg_chnr, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(auftgrec.ag_aknr), buch);
            END IF;
         END LOOP;--alle Lagerorte ablaufen und Mengen abbuchen!!!!!
         IF offen>0 THEN--wir buchen alles das was wir nicht buchen konnten auf minus!
             INSERT INTO lifsch (l_krz, l_krzl, l_krzf, l_aknr, l_ag_id, l_lgchnr, l_abg_mec, l_abgg, l_lgort) VALUES ('#', '#', '#', auftgrec.ag_aknr, auftgrec.ag_id, 'ABK='||$1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(auftgrec.ag_aknr), offen, 'MINUS');
         END IF;
        UPDATE auftg SET ag_done=TRUE WHERE ag_id=auftgrec.ag_id AND ag_stk<=ag_stkl;
     END LOOP;
     RETURN 0;
    END $$ LANGUAGE plpgsql;


 --
 CREATE OR REPLACE FUNCTION tplanterm.auto_folgt_lagbuch_intern(IN abix INTEGER, IN prozmenge NUMERIC, lgort VARCHAR, lgchnr VARCHAR) RETURNS VOID AS $$
    DECLARE
        ldsrec     RECORD;
        wwen       INTEGER;
        Menge      NUMERIC(12,4);
    BEGIN
     lgort  := COALESCE(lgort , '');
     lgchnr := COALESCE(lgchnr, '');
     FOR ldsrec IN SELECT ldsdok.* FROM ldsdok JOIN auftg ON ag_id=ld_ag_id WHERE ld_ag_id IN (SELECT * FROM tplanterm.get_all_child_auftg($1)) AND NOT ld_done AND ld_stk_uf1=ag_stk_uf1 AND ld_code='I' LOOP
        --Lagerzugang Unterproduktionsteil
        Menge:=ldsrec.ld_stk_uf1*$2;
        INSERT INTO wendat (w_aknr, w_lds_id, w_lgort, w_lgchnr, w_zug_mec, w_zugang) VALUES (ldsrec.ld_aknr, ldsrec.ld_id, lgort, lgchnr, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(ldsrec.ld_aknr), Menge) RETURNING w_wen INTO wwen;
        --UPDATE ldsdok SET ld_done=TRUE WHERE ld_id=ldsrec.ld_id AND ld_stk_uf1<=ld_stkl;
        --TODO: Wenn Kopfartikel mit einem Verhältnis geschlossen wurde, schliessen wir auch Unterartikel mit diesem Verhältnis. zB mit 9 von 10 Stück ist der Hauptartikel in seinem Produktinosauftrag erledigt
        --Lagerzugang ermöglicht nun Abbuchung, was wir auch gleich machen
        --INSERT INTO lifsch (l_krz, l_krzl, l_krzf, l_aknr, l_ag_id, l_lgort, l_lgchnr, l_abg_mec, l_abgg) SELECT '#', '#', '#', w_aknr, ldsrec.ld_ag_id, w_lgort, w_lgchnr, w_zug_mec, Menge FROM wendat WHERE w_wen=wwen;
     END LOOP;
     --Lagerabgang kommt ansonsten über Lagerabgang ABK bezogen
     RETURN;
    END $$ LANGUAGE plpgsql;



--Funktionen zur Verwaltung von Arbeitsgängen

--http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Abk

-- Erstellt oder aktualisiert den RM-Eintrag für eine Auswärtsrücklieferung
CREATE OR REPLACE FUNCTION tplanterm.update_rm_ausw(a2id INTEGER, wwen INTEGER, belpid INTEGER=NULL) RETURNS VOID AS $$
  DECLARE rec      RECORD;
          isInsert BOOLEAN;
          isWendat BOOLEAN;
  BEGIN
    IF (wwen IS NULL AND belpid IS NULL) OR (a2id IS NULL) THEN -- Wir sind wohl nur aus Versehen hier gelandet. Tschüss!
        RETURN;
    END IF;

    --Rücklieferung auf Auswärtsvergabe. Rückmeldung durch Wareneingang
    isWendat:= ((wwen IS NOT NULL) AND (belpid IS NULL));

    IF isWendat THEN
        isInsert:= NOT EXISTS(SELECT true FROM rm WHERE r_a2_id = a2id AND r_w_wen = wwen);
        SELECT w_zug_dat AS datum, a2_ks AS ks, w_zugang_uf1 AS menge, w_auss_uf1 AS ausschuss
        INTO rec
        FROM wendat JOIN ldsdok ON w_lds_id = ld_id
                    JOIN ab2 ON ld_a2_id = a2_id
        WHERE w_wen = wwen;
    ELSE -- Rückmeldung per Rechnung
        isInsert:= NOT EXISTS(SELECT true FROM rm WHERE r_a2_id = a2id AND r_belp_id = belpid);
        SELECT belp_erstelldatum::TIMESTAMP AS datum, a2_ks AS ks, belp_menge_gme AS menge, NULL::NUMERIC AS ausschuss
        INTO rec
        FROM eingrech_pos JOIN ab2 ON belp_a2_id = a2_id
        WHERE belp_a2_id = a2id
          AND belp_belegtyp = 'ERG'
          AND belp_aknr = a2_aknr;
    END IF;

    IF isInsert THEN -- Zeiteinheit sind immer Tage (bzw. Arbeitstage)
        INSERT INTO rm (r_a2_id, r_zeinh, r_da, r_ks, r_mat, r_as, r_w_wen, r_belp_id, r_minr)
        SELECT a2id, 4, rec.datum, rec.ks, rec.menge, rec.ausschuss, wwen, belpid, current_user_minr();
    ELSE
        IF isWendat THEN
            UPDATE rm SET r_da = rec.datum, r_ks = rec.ks, r_mat = rec.menge, r_as = rec.ausschuss
            WHERE r_a2_id = a2id AND r_w_wen = wwen;
        ELSE
            UPDATE rm SET r_da = rec.datum, r_ks = rec.ks, r_mat = rec.menge
            WHERE r_a2_id = a2id AND r_belp_id = belpid;
        END IF;
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql;
--

--Gibt A2_ID des vorhergehenden Arbeitsgangs zurück oder NULL beim ersten Arbeitsgang
CREATE OR REPLACE FUNCTION tplanterm.prev_ag(a2id INTEGER) RETURNS INTEGER AS $$ -- TODO DROP?! scheduler__ab2__resource_timeline__terminated_prior__a2_id__get
 BEGIN
  RETURN ag1.a2_id
        FROM ab2 ag1 JOIN ab2 ag2 ON ag1.a2_ab_ix = ag2.a2_ab_ix
        WHERE ag1.a2_n < ag2.a2_n AND ag2.a2_id = a2id
        ORDER BY ag1.a2_n DESC LIMIT 1;
 END $$ LANGUAGE plpgsql STABLE;

--Gibt A2_ID des nachfolgenden Arbeitsgangs zurück oder NULL beim letzten Arbeitsgang
CREATE OR REPLACE FUNCTION tplanterm.next_ag(a2id INTEGER) RETURNS INTEGER AS $$ -- TODO DROP?!
 BEGIN
  RETURN ag1.a2_id
        FROM ab2 ag1 JOIN ab2 ag2 ON ag1.a2_ab_ix = ag2.a2_ab_ix
        WHERE ag1.a2_n > ag2.a2_n AND ag2.a2_id = a2id
        ORDER BY ag1.a2_n ASC LIMIT 1;
 END $$ LANGUAGE plpgsql STABLE;

--Rückgemeldete Menge für einen Arbeitsgang
CREATE OR REPLACE FUNCTION tplanterm.rm_menge(a2id INTEGER) RETURNS NUMERIC(12,4) AS $$
 BEGIN
  RETURN SUM(r_mat) FROM rm WHERE r_a2_id=a2id;
 END $$ LANGUAGE plpgsql;

--Rückgemeldete Ausschussmenge für einen Arbeitsgang
CREATE OR REPLACE FUNCTION tplanterm.rm_ausschuss(a2id INTEGER) RETURNS NUMERIC(12,4) AS $$
 BEGIN
  RETURN SUM(r_as) FROM rm WHERE r_a2_id=a2id;
 END $$ LANGUAGE plpgsql;



--http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Abk

--Datum nach Auswärts gegeben => TODO in tabk?
CREATE OR REPLACE FUNCTION tplanterm.ausw_menge_send_dat(_a2id integer) RETURNS date
  AS $$
    SELECT min(ld_datum) FROM ldsdok WHERE NOT ld_storno AND ld_a2_id = _a2id;
  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;
--

--Menge nach Auswärts gegeben
CREATE OR REPLACE FUNCTION tplanterm.ausw_menge_send(_a2id integer) RETURNS numeric(12,4)
  AS $$
    SELECT sum(ld_stk_uf1) FROM ldsdok WHERE NOT ld_storno AND ld_a2_id = _a2id;
  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;
--

--Menge zurückgeliefert
CREATE OR REPLACE FUNCTION tplanterm.ausw_menge_rueck(_a2id integer) RETURNS numeric(12,4)
  AS $$
    SELECT sum(ld_stkl) FROM ldsdok WHERE NOT ld_storno AND ld_a2_id = _a2id;
  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;
--

--Rückmeldemenge gem. Eingangsrechnung / Verrechnete Menge durch Eingangsrechnung Auswärtsbearbeiter
CREATE OR REPLACE FUNCTION tplanterm.ausw_menge_rueck_rech(_a2id integer, _stichtag date DEFAULT NULL) RETURNS numeric(12,4)
  AS $$
    SELECT sum(belp_menge_gme)
      FROM eingrech_pos JOIN eingrech ON beld_id = belp_dokument_id
     WHERE belp_a2_id = _a2id
       AND belp_aknr NOT LIKE TSystem.Settings__Get('aknrtransport') -- Summiert nur, wenn Artikel in Rechnungsposition <> Transportartikel, sonst ist die Menge der Transportlieferung hier enthalten.
       AND (_stichtag IS NULL OR beld_erstelldatum <= _stichtag); -- nach Stichtag
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
--

--Gibt den Gesamtwert der Rechnungen des Auswärtsarbeitsgangs zurück. NULL wenn keine Rechnung, damit in diesem Fall mit COALESCE die Vorkalulation geholt werden kann
CREATE OR REPLACE FUNCTION tplanterm.ausw_rech_gesamt(_a2id integer, _stichtag date DEFAULT NULL) RETURNS numeric(12,4)
  AS $$
    --Summiert Kosten für Auswärtsbearbeitung und ggf. Transportrechnungen
    SELECT sum(belp_netto_basis_w)
      FROM eingrech_pos JOIN eingrech ON beld_id = belp_dokument_id
     WHERE belp_a2_id = _a2id
       AND (_stichtag IS NULL OR beld_erstelldatum <= _stichtag); -- nach Stichtag
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

-- Auswärtsrechnung pro Stk
CREATE OR REPLACE FUNCTION tplanterm.ausw_ep_rech_gesamt(a2id INTEGER, stichtag DATE DEFAULT NULL) RETURNS NUMERIC(12,4) AS $$
  BEGIN --TODO? Preis pro Stück kann Speditionsrechnungen etc. enthalten, hier mit berücksichtigen? Wie?
    RETURN tplanterm.ausw_rech_gesamt(a2id, stichtag)/Do1If0(tplanterm.ausw_menge_rueck_rech(a2id, stichtag));
  END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION tplanterm.auftg_nk_calc_vkp(
      _abix   integer,
      _agid   integer = null
  ) RETURNS void AS $$
  BEGIN
    -- Ermittelt und schreibt gewichteten Durchschnittspreises der Materialpositionen aus tatsächlichen Buchungen.
    -- Verwendung in tplanterm.buchrm, TBeleg.BelPreisBuchen


    -- keine Eingabeparameter, dann raus
    IF _abix IS NULL AND _agid IS NULL THEN
        RETURN;
    END IF;


    -- Ermittlung und Setzen des gewichteten Durchschnittspreises der Materialpositionen (MatPos) aus tatsächlichen Buchungen.
    UPDATE auftg SET
      ag_nk_calc_vkp_uf1 = nullif( einzelpreis_gewichtet, 0 )
    FROM (
        SELECT
          -- MatPos
          abk_mat.agid AS abk_mat_agid,
          -- gewichteter Einzelpreis
            -- gewichtet: Summe( Pos-Menge * Pos-Preis ) / Gesamtmenge
          sum(
                abgg_effektiv
              * coalesce(
                    -- kalkulierte Selbstkosten pro Fertigungsteil der Unter-ABK
                    nullif( ab_nk_et, 0 ),
                    -- oder Selbstkosten aus ER (EP netto inkl. Abzu und Rabatt, ohne VKP-Faktor - entspr. TBeleg.BelPreisBuchen)
                    erg_ep_gewichtet,
                    -- oder Selbstkosten aus externer Bestellung (EP netto inkl. Abzu und Rabatt, ohne VKP-Faktor - entspr. TBeleg.BelPreisBuchen)
                    ldsdok_ext.ld_netto_basis_w / Do1If0( ldsdok_ext.ld_stk_uf1 ),
                    -- Fallback auf Vorkalkulation laut MatPos bzw. Artikelstamm.
                    -- Wichtig bei Mischbetrieb von Unter-ABK mit und ohne NK, sowie dem Ausschluss von Nacharbeit/Reklamation.
                    nullif( ag_vkp_uf1, 0 ),
                    ak_hest
                )
          ) / Do1If0( sum (abgg_effektiv ) )
          AS einzelpreis_gewichtet

        FROM (
            -- ABK inkl. ABK zu Set-Artikel
            SELECT tplanterm.get_all_child_abk( _abix => _abix, _OnlySetAbk => true ) AS src_abks UNION SELECT _abix -- UNION für leere ab_ix notwendig
        ) AS all_abk
          -- tatsächlich gebuchte Lagermengen
          JOIN LATERAL tabk.abk_lifsch_materialnachweis(src_abks, _agid, true, false) AS abk_mat ON true
          -- zug. MatPos
          LEFT JOIN auftg                   ON ag_id = abk_mat.agid
          -- zur Fertigung zug. Bestellung (intern) um Nacharbeiten auszuschließen (siehe LEFT JOIN abk)
          LEFT JOIN ldsdok AS ldsdok_abk    ON ldsdok_abk.ld_abk = abk_mat.own_abk
          -- gebuchte Lagermenge kommt aus anderer Fertigung und ist keine Nacharbeit (verfälscht Preise)
          LEFT JOIN abk                     ON ab_ix = abk_mat.own_abk AND ldsdok_abk.ld_q_nr IS NULL
          -- gebuchte Lagermenge kommt aus Bestellung ohne ABK (extern) und ist keine Reklamation (verfälscht Preise)
            -- interne Bestellung wird nicht benötigt, da NK der ABK für Preis genommen wird.
          LEFT JOIN ldsdok AS ldsdok_ext    ON ldsdok_ext.ld_id = abk_mat.ldid AND abk_mat.own_abk IS NULL AND ldsdok_ext.ld_q_nr IS NULL
          -- Eingangsrechnungen (ERG) an externer Bestellung
          LEFT JOIN LATERAL (
              SELECT
                -- gewichteter Durchschnittspreis aller ERG an Bestellung
                sum( belp_netto_basis_w ) / Do1If0( sum( belp_menge_gme ) ) AS erg_ep_gewichtet
              FROM eingrech_pos
              WHERE belp_ld_id = ldsdok_ext.ld_id
                AND NOT belp_storniert
          ) AS erg ON ldsdok_ext.ld_id IS NOT NULL -- ERG nur wenn Bestellung gefunden
          -- Artikelstamm bzgl. Selbstkosten
          LEFT JOIN art ON ak_nr = abk_mat.mat_aknr

        WHERE
          -- Buchungen inkl. Rückführungen vorhanden
              abk_mat.is_effektiv
          -- mit Bezug zu MatPos. Freie Buchungen ohne MatPos derzeit nicht berücksichtigt
          AND abk_mat.agid IS NOT NULL
        -- gewichteter Einzelpreis je MatPos
        GROUP BY abk_mat.agid

    ) AS preis_anhand_realbuchungen

    WHERE
      -- Aktualisierung an dieser MatPos
          ag_id = abk_mat_agid
      AND ag_astat = 'I' -- Einschränkung auf Typ MatPos (sicherheitshalber)
      -- nur bei Änderung des Durchschnittspreises
      AND ag_nk_calc_vkp_uf1 IS DISTINCT FROM nullif( einzelpreis_gewichtet, 0 )
    ;

    -- Fallback auf Selbstkosten laut Artikelstamm
    -- Materialbedarfspositionen, welche zum Zeitpunkt der ABK-Erstellung keinen Preis hatten und auch jetzt keinen haben, füllen wir mit Preis aus Artikelstamm.
    UPDATE auftg SET
      ag_nk_calc_vkp_uf1 = ak_hest
    FROM art
    WHERE ak_nr = ag_aknr
      AND ak_hest > 0
      AND ag_parentabk = coalesce( _abix, ag_parentabk )    -- alle MatPos der ABK
      AND ag_id = coalesce( _agid, ag_id )                  -- oder bestimmte MatPos
      AND coalesce( ag_nk_calc_vkp_uf1, ag_vkp_uf1, 0 ) = 0
    ;


    RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;
--

-- Nachkalkulation parallele Personalkosten einer ABK zum entsprechenden Stundensatz und
-- summiert diese Kosten bis zum Arbeitsgang _n2_n_bis, oder eben alle der ABK, wenn dieser Parameter null sein sollte
CREATE OR REPLACE FUNCTION tplanterm.nk__pz_para__sum( _ab_ix integer, _n2_n_bis integer DEFAULT null ) RETURNS numeric AS $$

    SELECT coalesce(
        ( SELECT sum( coalesce( -- effektive Gesamtzeit in Stunden
                                  n2_ez_stu
                                -- Normstundensatz Bediener
                                * coalesce( nkk_nssm, ks_stsm )
                                -- Fertigungsgemeinkosten
                                * ( 1 + ab_nk_fgk / 100 )
                                , 0 ))
          FROM nk2
          JOIN abk on ab_ix = n2_ix
          JOIN ksv on ks_abt = n2_ks
          LEFT JOIN nkksv ON nkk_ab_ix = n2_ix AND nkk_ks = ks_abt
          WHERE
                n2_ix = _ab_ix
            AND n2_pz_para
            AND ( _n2_n_bis IS null OR n2_n <= _n2_n_bis )
        ),
    0 );

$$ LANGUAGE sql STABLE;


-- Nachkalkulation Fertigungskosten einer ABK zum entsprechenden Stundensatz und
-- summiert diese Kosten bis zum Arbeitsgang _n2_n_bis, oder eben alle der ABK, wenn dieser Parameter null sein sollte
CREATE OR REPLACE FUNCTION tplanterm.nk__kosten_fertigung_tr_ta__sum(
    IN  _ab_ix             integer,
    IN  _n2_n_bis          integer DEFAULT null,
    OUT zeit               numeric,
    OUT kosten_ruesten     numeric,
    OUT kosten_ausfuehrung numeric
  )
  RETURNS record
  AS $$

    SELECT
      -- gesamte Auftragszeit T
      sum( n2_ez_stu ) AS zeit,

      -- Kosten für Rüsten (tr)
        -- Stundensätze aus NK (bei ABK-Erstellung) bevorzugen
        -- inkl. Rüstkostenzuschlag
      sum(
          -- effektive Gesamtzeit in Stunden
            n2_ez_stu
          -- Normstundensatz Rüsten
          -- dabei Arbeitspaket-spezifischen Stundensatz bevorzugen
          * coalesce( kssa_stsr, nkk_nssr, ks_stsr )
          -- Rüstkostenzuschlag
          * ( 1 + ab_nk_rgk / 100 )
      )
        -- Rüsten
        FILTER ( WHERE n2_ruest )
      AS kosten_ruesten,

      -- Kosten für Ausführung (ta)
        -- Stundensätze aus NK (bei ABK-Erstellung) bevorzugen
        -- inkl. Fertigungsgemeinkosten
      sum(
          -- effektive Gesamtzeit in Stunden
            n2_ez_stu
          -- Normstundensatz Fertigen (Ausführung)
          -- dabei Arbeitspaket-spezifischen Stundensatz bevorzugen
          * coalesce( kssa_sts, nkk_nssf, ks_sts )
          -- Fertigungsgemeinkosten
          * ( 1 + ab_nk_fgk / 100 )
      )
        -- Ausführung
        FILTER ( WHERE NOT n2_ruest AND NOT n2_pz_para )
      AS kosten_ausfuehrung

    FROM nk2
      LEFT JOIN abk ON ab_ix = n2_ix
      LEFT JOIN ab2 ON a2_ab_ix = n2_ix AND a2_n = n2_n
      -- Sonderfall NK: Arbeitspaket-spezifischer Stundensatz (Sts) kssa_sts gilt vor NK-Sts, gilt vor KS-Sts.
        -- Verwendung von tartikel.ksv__data__by__ks_abt__kssa_ak_nr__get nicht zielführend, da andere Hierarchie
      JOIN ksv ON ks_abt = coalesce( n2_ks, a2_ks )
      LEFT JOIN ksv_stundensatz_art ON kssa_ks_abt = ks_abt AND kssa_ak_nr = a2_aknr
      LEFT JOIN nkksv ON nkk_ab_ix = n2_ix AND nkk_ks = ks_abt
    WHERE n2_ix = _ab_ix
      AND NOT n2_ausw
      AND NOT ks_notInCalc
      AND NOT ks_sondkost
      AND ( _n2_n_bis IS null OR n2_n <= _n2_n_bis )

$$ LANGUAGE sql STABLE;


-- Nachkalkulation
CREATE OR REPLACE FUNCTION tplanterm.buchrm(
      _abkix      integer,
      writeback   boolean
  ) RETURNS void AS $$
  DECLARE
      nkst        numeric; -- NK-Menge
      nkas        numeric; -- NK-Ausschuss
      nkmatr      numeric; -- Materialkosten Rohmat (inkl. Materialgemeinkosten)
      nkmatn      numeric; -- Materialkosten (inkl. VKP-Faktor und ohne Materialgemeinkosten)
      nkmate      numeric; -- Materialkosten Eigenproduktion (ohne Materialgemeinkosten)
      nklohn_tr   numeric; -- Kosten für Rüsten (inkl. Rüstkostenzuschlag)
      nklohn_ta   numeric; -- Kosten für Ausführung (inkl. Fertigungsgemeinkosten)
      nklohn      numeric; -- Kosten für Arbeitszeit (Rüsten + Ausführung)
      nkausw      numeric; -- Auswärtskosten (inkl. Auswärtsgemeinkosten)
      nk_pz_para  numeric; -- Parallele Personalzeit
      nk_zko      numeric; -- Summe der globaler Zuschläge auf Herstellkosten (Material, Arbeitszeit, Auswärts)
      nksondkost  numeric; -- Sonderkosten
      nkpreis     numeric(12,2); -- Preis der Nachkalkulation pro Einzelteil
      vkpreis     numeric(12,2); -- Preis der Vorkalkulation laut ASK pro Einzelteil
      nkdat       record;
      _t          text;
      _d          date;
      _r          ab2;
  BEGIN

    -- Beachte: Das wird vom Programm her mit GetAllChildABK aufgrufen!
    IF NOT EXISTS(SELECT true FROM abk WHERE ab_ix = _abkix) THEN RETURN; END IF; -- Nicht vorhandene ABK ausschließen und raus.

    PERFORM disablemodified();
    PERFORM execution_code__disable( _flagname => 'auftg' );

    -- Automatisch übernommene, bereits verbuchte Einträge in Nachkalkulation rückgängig machen.
    DELETE FROM nk2 WHERE n2_a2_id IN (SELECT a2_id FROM ab2 WHERE a2_ab_ix = _abkix AND NOT a2_buch);

    /* => stornierte ABKs werden ab sofort nachkalkuliert und als Sonderkosten in die Übergeordnete ABK übernommen
    -- Stornierte ABK ausschließen und Verbuchungsstatus für Oberflächen setzen.
    IF EXISTS(SELECT true FROM abk WHERE ab_ix = _abkix AND ab_storno) THEN
        UPDATE abk SET ab_buch= true, ab_nk_date= current_date, ab_nk_change= false WHERE ab_ix = _abkix;
        UPDATE ab2 SET a2_interm= false, a2_buch= true WHERE a2_ab_ix = _abkix AND a2_ende AND NOT a2_buch;

        PERFORM enablemodified();
        PERFORM execution_code__enable( _flagname => 'auftg' );
        RETURN; -- und raus
    END IF;
    */

    -- alle Arbeitsgänge, welche noch nicht verbucht sind nun in die Nachkalkulation übertragen
    INSERT INTO nk2 (n2_a2_id, n2_n, n2_ix,    n2_ll,  n2_ks, n2_ksap, n2_ausw, n2_ez_stu,
                     n2_mat,     n2_as,     n2_ruest,                 n2_pz_para)
      -- Fertigung und Rüsten
      -- Rückmeldungen beziehen sich immer auf interne Kostenstellen, deswegen ist n2_ausw stets false
      SELECT         a2_id,    a2_n, a2_ab_ix, r_minr, r_ks, a2_ksap, false, sum(r_std_sek) / 3600,
                     sum(r_mat), sum(r_as), coalesce(r_ruest, false), false
        FROM ab2
        JOIN rm ON a2_id = r_a2_id
       WHERE a2_ab_ix = _abkix
         AND a2_ende
         AND NOT a2_buch
       GROUP BY a2_id, a2_n, a2_ab_ix, r_minr, r_ks, a2_ksap, a2_ausw, r_ruest

      -- Dummydatensätze für Auswärtsbearbeitungen ohne Rückmeldungen > https://redmine.prodat-sql.de/issues/19596
      UNION

      SELECT         a2_id,    a2_n, a2_ab_ix, null, null,  a2_ksap, true, null,
                     null, null, false, false
        FROM ab2
       WHERE a2_ab_ix = _abkix
         AND a2_ende
         AND NOT a2_buch
         AND a2_ausw
         AND NOT EXISTS( SELECT 1 FROM rm WHERE a2_id = r_a2_id )

      -- Hinzufügen paralleler Personalzeiten
        -- siehe auch https://help.prodat-erp.de/index.html?opl_register_op2_ag.html
        -- Jede in der Nachkalkulation erfasste Hauptzeit wird um eine parallele Personalzeit (PPZ) ergänzt,
        --   wenn in der Vorkalkulation eine solche angegeben wurde.
        -- Die hinzugefügte PPZ errechnet sich so: rückgemeldete Bearbeitungszeit (ohne Verteilzeit) * vorkalkulierte PPZ / vorkalkulierte Hauptzeit+Nebenzeit.
        -- Dies geschieht für jeden Datensatz in der Tabelle rm ohne Rüsten.
        -- Bei fehlenden oder unsinnigen Zeiten wird keine PPZ zur Nachkalkulation erfasst.
      UNION

      SELECT         a2_id,    a2_n, a2_ab_ix, r_minr, r_ks,  a2_ksap, false,   sum(r_std_sek) / 3600 / (1 + a2_tv/100) * a2_tm / (a2_th + a2_tn),
                     0,          0,         false,                    true
        FROM ab2
        LEFT JOIN rm ON a2_id = r_a2_id
       WHERE a2_ab_ix = _abkix
         AND a2_ende
         AND NOT a2_buch
         AND NOT r_ruest -- parallele Personalzeit nur auf Hauptzeiten
         AND coalesce( a2_th, 0 ) > 0 AND coalesce( a2_tm, 0 ) > 0 -- parallele Personalzeit nur falls Hauptzeiten und parallele Zeit definiert
       GROUP BY a2_id, a2_n, a2_ab_ix, r_minr, r_ks, a2_ksap, a2_ausw;
    --

    -- Todo - prüfen ob der Verbucht-Status in die RM übernommen wird und a2_buch entfernen

    -- Menge Nachkalkulation ermitteln zum Aufteilen der Stückkosten
        SELECT SUM(COALESCE(n2_mat, 0)) INTO nkst FROM nk2 WHERE n2_ix = _abkix AND n2_n = (SELECT max(a2_n) FROM ab2 JOIN rm ON a2_id = r_a2_id WHERE a2_ab_ix = _abkix AND NOT a2_ausw); -- Stückzahl vom letzten gemeldeten Arbeitsgang
        IF COALESCE(nkst, 0) = 0 THEN
            nkst := COALESCE(nullif(ab_nk_st_uf1, 0), ld_stkl) FROM ldsdok JOIN abk ON ab_ix = ld_abk WHERE ld_abk = _abkix; -- zu kalkulierende Menge aus ABK holen, wenn PA vorhanden. Wenn nicht angg. bzw. 0, dann gelieferte Menge aus PA.
            -- und in den letzten Arbeitsgang der Arbeitsgänge rein
            UPDATE nk2 SET n2_mat= COALESCE(nkst, 0) WHERE n2_id = (SELECT n2_id FROM nk2 WHERE n2_ix = _abkix ORDER BY n2_n DESC LIMIT 1) AND n2_mat <> COALESCE(nkst, 0);
        END IF;
        IF COALESCE(nkst, 0) = 0 THEN -- Menge der Nachkalkulation darf nicht 0 sein
            IF NOT EXISTS(SELECT true FROM ldsdok WHERE ld_abk = _abkix) THEN -- Bei Projekt oder Set
            -- ELSIF EXISTS(SELECT true FROM anl WHERE an_ab_ix = tplanterm.abk_main_abk(_abkix)) THEN
                nkst := 1; -- Projektnachkalkulation, alle Kosten auf 1 Projekt; derzeit wegen Prüfung auf ldsdok sowieso ohne Wirkung
            ELSIF COALESCE((SELECT SUM(n2_as) FROM nk2 WHERE n2_ix = _abkix), 0) > 0 THEN -- Ausschuss, Stückzahl bleibt 0
            ELSIF ( SELECT ab_storno FROM abk WHERE ab_ix = _abkix ) THEN -- storniert, Stückzahl bleibt 0
            ELSE
                _t:= lang_text(2401) || _abkix;
                RAISE EXCEPTION '%', _t; -- Menge Nachkalkulation ist 0, bitte Stueckzahl melden: entweder durch Lagerzugang, oder durch eine Rückmeldemenge im letzten rückgemeldeten Arbeitsgang (Rückmeldungen); ABK:%
            END IF;
        END IF;

        SELECT SUM(COALESCE(n2_as, 0)) INTO nkas FROM nk2 WHERE n2_ix = _abkix; -- insgesamter Ausschuss

        IF current_user = 'root' THEN
            RAISE NOTICE 'Fertigungsmenge: %, Ausschuss: %', nkst, nkas;
        END IF;
    --

    -- aktuellen Werte in ABK zurückschreiben
      -- Hinweis: System-Defaults für Gemeinkosten bei ABK-Erstellung per tabk.abk__create
    UPDATE abk SET
      -- Verbuchungsstatus, Buchungszeitpunkt
      ab_buch       = true,
      ab_nk_date    = current_date,
      -- gefertigte Menge und Ausschuss (Fallback auf Defaults. Werte s.o.)
      ab_nk_st_uf1  = coalesce( nkst, 0 ),
      ab_nk_auss    = coalesce( nkas, 0 )
    WHERE ab_ix = _abkix
    ;

    -- Arbeitsgänge als verbucht kennzeichnen
    UPDATE ab2 SET a2_buch = true WHERE a2_ab_ix = _abkix AND a2_ende AND NOT a2_buch;

    -- Ausschuss Komplettkosten auf 1 Produktionsauftrag
    IF nkst = 0 THEN -- Wenn Stückzahl 0 bei Ausschuss.
        nkst:= 1; -- Dann werden die kompletten Kosten auf den Aussschuss gebucht (Anzahl 1   -1 mal Ausschuss für alles)
    END IF;

    -- Kostenblöcke
        -- Fertigungsartikel bzw. AP im Projekt und ABK-Daten
        SELECT
          coalesce(ld_aknr, an_ak_nr) AS ld_aknr,
          ab_askix, ab_nk_date, ab_nk_st_uf1, ab_st_uf1, ab_storno, ab_parentabk,
          -- Gemeinkostenzuschläge bei ABK-Erstellung
          ab_nk_mgk, ab_nk_rgk, ab_nk_fgk, ab_nk_agk
        FROM abk
          LEFT JOIN ldsdok ON ld_abk = ab_ix
          LEFT JOIN anl ON an_ab_ix = ab_ix
        WHERE ab_ix = _abkix
        INTO nkdat
        ;

        -- Ermittlung des gewichteten Durchschnittspreises
            -- Wir berechnen den tatsächlichen Nachkalkulationspreis dieses Teils, dazu jetzt die tatsächlichen Preise der Unterbauteile!
            -- Schreibt gewichteten Durchschnittspreises der Materialpositionen aus tatsächlichen Buchungen in ag_nk_calc_vkp_uf1
            -- Fallback auf Selbstkosten in Funktion
            PERFORM tplanterm.auftg_nk_calc_vkp( _abkix );
        --


        -- 1. Materialbedarfe und Unterbauteile
            SELECT
              -- Rohmaterialien
                -- kein Unterbauteil, (DS) Wenn eigene ABK, dann immer in Einzel-/Montageteile-Block, egal welchen Status ag_post2 (sowieso Mist)
                -- überschriebene NK-Werte (ag_nk...) bevorzugen
                -- inkl. Materialgemeinkosten
              sum(
                  -- Menge
                    coalesce( ag_nk_stkl_uf1, ag_stkl )
                  -- Selbstkosten
                    -- Korrektur laut NK, NK-Durchschnittspreis laut Verbuchung, Preis laut VK bzw. Einkauf bei ABK-Erstellung
                  * coalesce( ag_nk_vkp_uf1, ag_nk_calc_vkp_uf1, ag_vkp_uf1 )
                  -- Materialgemeinkostenzuschlag
                  * ( 1 + nkdat.ab_nk_mgk / 100 )

              )
                -- Rohmaterial und Normteile ohne eigenen ABK
                FILTER ( WHERE ag_post2 = 'R' AND ag_ownabk IS NULL )
              AS kosten_rohmaterialien,


              -- Normteile
                -- überschriebene NK-Werte (ag_nk...) bevorzugen
                -- inkl. VKP-Faktor und ohne Materialgemeinkosten, vgl. #15331
              sum(
                  -- Menge
                    coalesce( ag_nk_stkl_uf1, ag_stkl )
                  -- Selbstkosten
                    -- Korrektur laut NK, NK-Durchschnittspreis laut Verbuchung, Preis laut VK bzw. Einkauf bei ABK-Erstellung
                  * coalesce( ag_nk_vkp_uf1, ag_nk_calc_vkp_uf1, ag_vkp_uf1 )
                  -- Verkaufspreis-Faktor laut Artikelstamm bzw. AC
                  -- #19308 Per dynamischer Einstellung soll der Verkaufspreisfaktor für Normteile ignoriert werden können.
                  * CASE
                      WHEN tsystem.settings__getbool( 'PREIS_NORMTEILE_OHNE_VKP_FAKTOR' ) THEN 1
                      ELSE coalesce( nullif( ak_vkpfaktor, 0 ), nullif( ac_vkpfaktor, 0 ), 1 ) END
              )
                -- Normteile ohne eigenen ABK
                FILTER ( WHERE ag_post2 = 'N' AND ag_ownabk IS NULL )
              AS kosten_normteile,


              -- Einzel- und Montageteile
                -- Unterbauteil, (DS) ACHTUNG: eigene ABK, dann in Montageteile-Block
                -- überschriebene NK-Werte (ag_nk...) bevorzugen
                -- ohne VKP-Faktor und ohne Materialgemeinkosten, vgl. #15068
              sum(
                  -- Menge
                    coalesce( ag_nk_stkl_uf1, ag_stkl )
                  -- Selbstkosten
                    -- Korrektur laut NK, NK-Durchschnittspreis laut Verbuchung, Preis laut VK bzw. Einkauf bei ABK-Erstellung
                    -- Beachte: nachkalkulierte Unterbauteile sind in NK-Durchschnittspreis enthalten.
                  * coalesce( ag_nk_vkp_uf1, ag_nk_calc_vkp_uf1, ag_vkp_uf1 )
              )
                -- Einzel- und Montageteile und MatPos mit eigener ABK
                FILTER ( WHERE ( ag_post2 IN ('E', 'M') OR ag_ownabk IS NOT NULL ) )
              AS kosten_unterbauteile

            FROM auftg
              JOIN art ON ak_nr = ag_aknr
              JOIN artcod ON ac_n = ak_ac
            WHERE ag_parentabk IN ( SELECT tplanterm.get_all_child_abk( _abix => _abkix, _OnlySetAbk => true ) )
              -- keine Beistellung durch Kunden, siehe #11316
              AND NOT TSystem.Enum_GetValue(ag_stat, 'BK')
            INTO
              nkmatr, -- kosten_rohmaterialien
              nkmatn, -- kosten_normteile
              nkmate  -- kosten_unterbauteile
            ;


            -- Kosten anteilig der NK-Menge
            nkmatr := coalesce( nkmatr, 0 ) / nkst; -- Rohmaterialien
            nkmatn := coalesce( nkmatn, 0 ) / nkst; -- Normteile
            nkmate := coalesce( nkmate, 0 ) / nkst; -- Einzel-/Montageteile


            -- Debug-Ausgabe per root
            IF current_user = 'root' THEN
                RAISE NOTICE 'Rohmaterialien: %', nkmatr;
                RAISE NOTICE 'Normteile: %', nkmatn;
                RAISE NOTICE 'Einzel- + Montageteile: %', nkmate;
            END IF;
        --


        -- 2. Fertigungskosten
            SELECT kosten_ruesten, kosten_ausfuehrung
              INTO nklohn_tr     , nklohn_ta
              FROM tplanterm.nk__kosten_fertigung_tr_ta__sum( _abkix )
            ;


            -- Kosten anteilig der NK-Menge
            nklohn := ( coalesce( nklohn_tr, 0 ) + coalesce( nklohn_ta, 0 ) ) / nkst;


            -- Debug-Ausgabe per root
            IF current_user = 'root' THEN
                RAISE NOTICE 'Fertko tr: %', nklohn_tr;
                RAISE NOTICE 'Fertko ta: %', nklohn_ta;
                RAISE NOTICE 'Fertko T: % (nkst : %)', nklohn, nkst;
            END IF;
        --


        -- 3. Auswärtskosten
            SELECT
              CASE WHEN NOT TSystem.Settings__GetBool('AUSW_AUTO_VORKALK') THEN -- Setting "Vorgabewerte für Auswärts verwenden"
                  SUM(COALESCE(tplanterm.ausw_rech_gesamt(a2_id), 0)) -- Gesamte Auswärtskosten an AG ohne Vorgabewerte
              ELSE
                  SUM(COALESCE(tplanterm.ausw_rech_gesamt(a2_id), -- Wenn noch keine Rechnung vorliegt, Vorgabe aus AVOR nehmen und verrechnen mit vergebene, rückgelieferte, verrechnete bzw. Fertigungsmenge. Identisch zu Report "Nachkalkulation"
                               o2_awpreis * COALESCE(tplanterm.ausw_menge_rueck_rech(a2_id), -- verrechnete Menge (eigentlich unnötig, aber identisch zum report)
                                                     tplanterm.ausw_menge_rueck(a2_id),      -- rückgelieferte Menge
                                                     tplanterm.ausw_menge_send(a2_id),       -- vergebene Menge
                                                     ab_st_uf1                               -- Fertigungsmenge
                                                    ),
                               0
                              )
                     )
              END
            INTO nkausw
            FROM ab2
              JOIN abk ON ab_ix = a2_ab_ix
              LEFT JOIN op2 ON o2_id = a2_o2_id
            WHERE a2_ab_ix = _abkix;


            -- Kosten anteilig der NK-Menge + Auswärtsgemeinkosten aufschlagen
            nkausw := coalesce( nkausw, 0 ) / nkst * ( 1 + nkdat.ab_nk_agk / 100 );


            -- Debug-Ausgabe per root
            IF current_user = 'root' THEN
                RAISE NOTICE 'Auswärts: %', nkausw;
            END IF;
        --

        -- 4. Parallele Personalzeit, Kosten anteilig der NK-Menge
            nk_pz_para := tplanterm.nk__pz_para__sum( _abkix )  / nkst;

        -- 5. Globale Zuschläge
            nk_zko :=
                  -- Satz der Zuschläge
                    sum( n7zk_proz ) / 100
                  -- angewandt auf Wertschöpfungsebene
                    -- also Herstellkosten ohne Unterbauteile, siehe #15249
                  * ( nkmatr + nkmatn + nklohn + nk_pz_para + nkausw )
                FROM nk7zko
                WHERE n7zk_ab_ix = _abkix
                  AND n7zk_proz IS NOT NULL
            ;


            -- Kosten bereits anteilig der NK-Menge
            nk_zko := coalesce( nk_zko, 0 );


            -- Debug-Ausgabe per root
            IF current_user = 'root' THEN
                RAISE NOTICE 'Globale Zuschläge: %', nk_zko;
            END IF;
        --


        -- 6. Sonderkosten
            -- ER an ABK (Spedition) sowie EinzelPreis-wirksame Sonderkosten laut NK und AG-KS
            -- alle Sonderkosten anteilig der NK-Menge
            nksondkost := coalesce( tabk.get_sonder_kosten( _abkix ), 0 ) / nkst;


            -- Debug-Ausgabe per root
            IF current_user = 'root' THEN
                RAISE NOTICE 'Sonderkosten: %', nksondkost;
            END IF;
        --


        -- Ergebnis: Selbstkosten pro kalkuliertem Fertigungsteil (NK-Menge)
            -- das sind die Gesamtkosten inkl. jeweiliger Gemeinkosten:
            -- Materialien, Unterbauteile, Fertigungskosten, Auswärtskosten, globale Zuschläge, Sonderkosten
            nkpreis := nkmatr + nkmatn + nkmate + nklohn + nkausw + nk_pz_para + nk_zko + nksondkost;
            nkpreis := coalesce( nkpreis, 0 );


            -- Debug-Ausgabe per root
            IF current_user = 'root' THEN
                RAISE NOTICE 'Gesamtkosten: %', nkpreis;
            END IF;
        --
    --

    -- unstimmig: Stückpreis der Vorkalkulation (VK) laut ASK anhand der geplanten Fertigungsmenge
        -- Problem: Baugruppen-Kosten der VK werden hiermit nicht ermittelt sondern nur Kosten auf Artikelebene-Ebene (Einzelteil-Kosten). Diese werden aber mit den gesamten Baugruppen-Kosten der NK verglichen.
        -- vkpreis:= tartikel.op2_rkost(nkdat.ab_askix, nkdat.ab_st_uf1) + tartikel.op2_mkost(nkdat.ab_askix) + tartikel.op2_akost(nkdat.ab_askix) + tartikel.op6_kost(nkdat.ab_askix);
    -- stattdessen VK (gesamte Baugruppen-Kosten) aus Artikelstamm
        vkpreis:= ak_hest FROM art WHERE ak_nr = nkdat.ld_aknr;
    --

    -- Preis eintragen bzw. rückschreiben in ABKs
        -- Kalkulationsergebnis in eigene ABK (zur Weitergabe an übergeordnete ABKs)
        UPDATE abk SET
          -- NK ist erfolgt
          ab_nk_change  = false,
          -- nachkalkulierte Selbstkosten pro Fertigungsteil (NK-Menge)
          ab_nk_et      = nkpreis,
          -- Kosten für Rohmaterialien (inkl. Materialgemeinkosten) und Normteile (inkl. VKP-Faktoren), exkl. globaler Zuschläge.
          ab_nk_mat     = nkmatr + nkmatn
        WHERE ab_ix = _abkix
          AND (
                  ab_nk_change
              OR  ab_nk_et  IS DISTINCT FROM nkpreis
              OR  ab_nk_mat IS DISTINCT FROM nkmatr + nkmatn
          )
        ;

        -- Kalkulationsergebnis direkt in Kundenauftrag
          -- Verwendung ASK, Kundenrentabilität
          -- Selbstkosten (nicht VKP-Basis)
        UPDATE auftg SET
          ag_nk_vkp = nkpreis
        FROM ldsdok
        WHERE ld_ag_id = ag_id
          AND ld_abk = _abkix
          AND ag_astat = 'E'
        ;

        -- Aktualisierung der Preise von Unterbauteilen in anderen Fertigungen
            -- Vorkalkulationspreis aktualisieren
            UPDATE auftg SET
              ag_vkp = vkpreis
            WHERE ag_ownabk = _abkix
              AND ag_astat = 'I'
              AND ag_vkp IS DISTINCT FROM vkpreis
            ;

            -- Aktualisierung der Materialpositionen, die anhand Buchungen diese ABK verwendet haben. Durchschnittspreis aus versch. ABK, Bestellungen, ERG neu berechnen.
            PERFORM tplanterm.auftg_nk_calc_vkp( null, agids ) -- auch hier wird ab_nk_change auf true
            FROM (SELECT DISTINCT l_ag_id AS agids FROM ldsdok JOIN lifsch ON l_ld_id = ld_id WHERE l_ag_id IS NOT NULL AND ld_abk = _abkix) AS sub; -- LA kommt aus Bestellung und wird für MatPos verwendet. Bestellung ist unsere PA der ABK.
        --

        -- Kalkulationsergebnis in Sondereinzelkosten der Parent-ABK übernehmen, wenn ABK storniert ist
        IF nkdat.ab_parentabk IS NOT NULL AND nkdat.ab_storno THEN
          DELETE FROM nkz WHERE nz_ab_ix = nkdat.ab_parentabk AND nz_text = 'Stono-ABK ' || _abkix;
          INSERT INTO nkz ( nz_ab_ix          , nz_pos                                                                            , nz_ad_krz, nz_text               , nz_stk, nz_ep  , nz_betrag )
                 SELECT     nkdat.ab_parentabk, (SELECT coalesce(max(nz_pos),0) + 10 FROM nkz WHERE nz_ab_ix = nkdat.ab_parentabk), '#'      , 'Stono-ABK ' || _abkix, 1     , nkpreis, nkpreis   ;
        END IF;
        --
    --

    -- Berechnung der Summe der Rohmaterialen (ac_i = 3) der Baugruppe / Einzelteile
    UPDATE abk SET
      ab_nk_matr_et = d.cost_et,
      ab_nk_matr_bg = d.cost_bg
    FROM (
        SELECT
          coalesce( sum( c.costs ) FILTER ( WHERE c.ab_ix = _abkix  ), 0 )  AS cost_et,
          coalesce( sum( c.costs ), 0 )                                     AS cost_bg
        FROM (
            SELECT
              ab_ix,

              -- Kosten bzgl. Materialien und Unterbauteilen, siehe Kostenblock oben.
              -- Menge
                coalesce( mat.ag_nk_stkl_uf1, mat.ag_stkl )
              -- Selbstkosten
              * coalesce( mat.ag_nk_vkp_uf1, mat.ag_nk_calc_vkp_uf1, mat.ag_vkp_uf1 )
              -- Zuschläge
              * CASE
                  -- Materialgemeinkosten nur bei Rohmaterialien
                  WHEN mat.ag_post2 = 'R' AND mat.ag_ownabk IS NULL THEN
                      ( 1 + ab_nk_mgk / 100 )
                  ELSE 1
                END
              AS costs

            FROM abk
              JOIN auftg AS mat ON mat.ag_parentabk = ab_ix
              JOIN art          ON ak_nr = ag_aknr
              JOIN artcod       ON ac_n  = ak_ac
            WHERE ab_ix = ANY( SELECT * FROM tplanterm.get_all_child_abk( _abkix ) )
              AND NOT TSystem.Enum_GetValue( mat.ag_stat, 'BK' )
              AND ac_i = 3
        ) AS c
    ) AS d
    WHERE ab_ix = _abkix
      AND (
              ab_nk_matr_et IS DISTINCT FROM d.cost_et
          OR  ab_nk_matr_bg IS DISTINCT FROM d.cost_bg
      )
    ;


    -- Option: Nachkalkulationswert in Lieferantendaten speichern!
    -- Selbstkosten (nicht VKP-Basis)
    -- Nur wenn nicht storniert
    IF writeback AND nkdat.ld_aknr IS NOT NULL AND NOT nkdat.ab_storno THEN
        SELECT e_txt, e_gdatum INTO _t, _d FROM epreis WHERE e_herkunft = 'ABK-' || _abkix; -- Text speichern, falls schon mal was zusätzliches eingegeben wurde
        DELETE FROM epreis WHERE e_herkunft = 'ABK-' || _abkix;
        INSERT INTO epreis (e_aknr,        e_herkunft,       e_lkn, e_gdatum,                       e_ep,    e_waer,                           e_stk,              e_mcv,                                                              e_txt)
        SELECT              nkdat.ld_aknr, 'ABK-' || _abkix, '#',   COALESCE(_d, nkdat.ab_nk_date), nkpreis, TSystem.Settings__Get('BASIS_W'), nkdat.ab_nk_st_uf1, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(nkdat.ld_aknr), _t;
    END IF;


    PERFORM enablemodified();
    PERFORM execution_code__enable( _flagname => 'auftg' );


    RETURN;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION tplanterm.buchrm_auftbuch(_abkix INTEGER) RETURNS VOID AS $$
  DECLARE
    _summe  NUMERIC(12,2);
    _mkost  NUMERIC(12,4);
    _akost  NUMERIC(12,4);
    _s      NUMERIC(12,4);
    r       RECORD;
    aks     RECORD;
    nkdat   RECORD;
  BEGIN
    SELECT * INTO nkdat FROM abk JOIN ldsdok ON ld_abk=ab_ix WHERE ab_ix=$1;
    --Aufteilungsbuchgungen für Rechnungen
    FOR r IN SELECT belzeil_grund.*, ld_abk
             FROM belzeil_grund
               JOIN belkopf ON be_bnr=bz_be_bnr
               JOIN belegpos ON bz_belp_id = belp_id
               LEFT JOIN auftg ON ag_id=belp_ag_id
               LEFT JOIN ldsdok ON ld_ag_id=ag_id
             WHERE bz_buchdat IS NULL
               AND belp_belegtyp = 'LFS'
               AND bz_aknr=nkdat.ld_aknr
               AND (ld_abk=_abkix OR ld_abk IS NULL)
               AND be_bdat>current_date-120
               AND (COALESCE(bz_ab_ix,0)=_abkix
                    OR NOT EXISTS(SELECT true FROM belauftbuch WHERE bab_bz_bnr=bz_be_bnr AND bab_bz_pos=bz_pos))
    LOOP
        --aufteilungsbuchung für diese Belegzeile erstellen
        --alte Buchungen löschen
        DELETE FROM belauftbuch WHERE bab_bz_bnr=r.bz_be_bnr AND bab_bz_pos=r.bz_pos;
        --
        _mkost:=0;
        _akost:=0;
        _summe:=0;
        --
        FOR aks IN SELECT abk__kosten__aufteilbuch_pro_ks__by__abix__nk.*, ks_abt, COALESCE(ks_allg1, ks_abt) AS ks_krzl FROM tabk.abk__kosten__aufteilbuch_pro_ks__by__abix__nk(_abkix) JOIN ksv ON ks_abt=ks LOOP
            _mkost:=aks.mkost*r.bz_fakt;
            _akost:=aks.akost*r.bz_fakt;
            _s:=(r.bz_fakt*r.bz_vkp_basis_w*(1-r.bz_arab/100)-_mkost-_akost)*aks.anteil;
            _summe:=_summe+COALESCE(_s,0);
            --
            IF COALESCE(_s,0)<0 THEN
                RAISE EXCEPTION '%', Format(lanf_text(29147) /*'Negativwert bei Kostenstelle: %'*/, aks.ks_abt);
            END IF;
            --
            IF COALESCE(_s,0)<>0 THEN
                INSERT INTO belauftbuch(bab_bz_bnr, bab_bz_pos, bab_ks, bab_netto) VALUES (r.bz_be_bnr, r.bz_pos, aks.ks_abt, _s);
            END IF;
        END LOOP;
        --
        IF COALESCE(_mkost,0)<0 THEN
            RAISE EXCEPTION '%', Format(lang_text(29148));  -- 'Negativwert bei Materialkosten.';
        END IF;
        IF COALESCE(_akost,0)<0 THEN
            RAISE EXCEPTION '%', Format(lang_text(29149));  -- 'Negativwert bei Auswärtskosten.';
        END IF;
        --materialbuchung zum Schluß
        IF COALESCE(_mkost,0)<>0 THEN
            INSERT INTO belauftbuch(bab_bz_bnr, bab_bz_pos, bab_ks, bab_netto) VALUES (r.bz_be_bnr, r.bz_pos, 'MAT', _mkost);
        END IF;
        --Auswärtskostenbuchung zum Schluß
        IF COALESCE(_akost,0)<>0 THEN
            INSERT INTO belauftbuch(bab_bz_bnr, bab_bz_pos, bab_ks, bab_netto) VALUES (r.bz_be_bnr, r.bz_pos, '9999', _akost);
        END IF;
        --eintragen das diese aufteilungsbuchgun aus dieser abk kam
        UPDATE belzeil_grund SET bz_ab_ix=_abkix, bz_buchdone=true WHERE bz_be_bnr=r.bz_be_bnr AND bz_pos=r.bz_pos;
    END LOOP;--alle Rechnungen die bisher keine Aufteilungsbuchung hatten ODER deren Aufteilungsbuchgung aus der ABK kommen die gerade aktualisiert wird.
    RETURN;
  END$$LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION tplanterm.buchfak_auftbuch_art(belzeil_id INTEGER) RETURNS VOID AS $$
  DECLARE
    r RECORD;
    aknr VARCHAR;
    bnr  VARCHAR;
    pos  INTEGER;
    wert  NUMERIC;
    awteil NUMERIC;
    matteil NUMERIC;
    buchdat    DATE;
  BEGIN
    SELECT bz_aknr, bz_be_bnr, bz_pos, bz_tot, bz_buchdat INTO aknr, bnr, pos, wert, buchdat FROM belzeil_grund WHERE bz_id=belzeil_id;
    --
    IF buchdat IS NOT NULL THEN
        RETURN;
    END IF;
    --
    DELETE FROM belauftbuch WHERE bab_bz_bnr=bnr AND bab_bz_pos=pos;
    --
    FOR r IN SELECT
               last_abix.*,
               ks_abt,
               COALESCE(ks_allg1, ks_abt) AS ks_krzl
             FROM tabk.abk__kosten__aufteilbuch_pro_ks__by__aknr__nk__last_abix(aknr) AS last_abix
               JOIN ksv ON ks_abt=ks
    LOOP
        awteil:=r.aKost;
        matteil:=r.mKost;
        IF r.anteil*(wert-awteil-matteil) IS NOT NULL THEN
            INSERT INTO belauftbuch(bab_bz_bnr, bab_bz_pos, bab_ks, bab_netto) VALUES (bnr, pos, r.ks, r.anteil*wert);
        END IF;
    END LOOP;
    --
    IF COALESCE(awteil,0)<>0 AND COALESCE(awteil*wert,0)<>0 THEN
        INSERT INTO belauftbuch(bab_bz_bnr, bab_bz_pos, bab_ks, bab_netto) VALUES (bnr, pos, '9999', awteil);
    END IF;
    --
    IF COALESCE(matteil,0)<>0 AND COALESCE(matteil*wert,0)<>0 THEN
        INSERT INTO belauftbuch(bab_bz_bnr, bab_bz_pos, bab_ks, bab_netto) VALUES (bnr, pos, 'MAT', matteil);
    END IF;
    --
    --buchungen auf done setzen für freigabe bzw. fertig
    PERFORM execution_code__disable( _flagname => 'belzeil' );
    UPDATE belzeil_grund SET bz_buchdone=TRUE WHERE bz_id=belzeil_id;
    PERFORM execution_code__enable( _flagname => 'belzeil' );
    --
    RETURN;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION tplanterm.ks_anz_maschine(varchar) RETURNS integer AS $$
    DECLARE
        ks ALIAS FOR $1;
        ksvrecord   record;
        anzm        integer;
    BEGIN
     --die Daten der Kostenstelle laden!
     SELECT * FROM ksv INTO ksvrecord WHERE ks_abt = ks;
     anzm := 1;

     IF coalesce(ksvrecord.ks_ba1, 0) > 0 THEN
        anzm := 2;
     END IF;
     IF coalesce(ksvrecord.ks_ba2, 0) > 0 THEN
        anzm := 3;
     END IF;
     IF coalesce(ksvrecord.ks_ba3, 0) > 0 THEN
        anzm := 4;
     END IF;
     IF coalesce(ksvrecord.ks_ba4, 0) > 0 THEN
        anzm := 5;
     END IF;
     IF coalesce(ksvrecord.ks_ba5, 0) > 0 THEN
        anzm := 6;
     END IF;
     IF coalesce(ksvrecord.ks_ba6, 0) > 0 THEN
        anzm := 7;
     END IF;
     IF coalesce(ksvrecord.ks_ba7, 0) > 0 THEN
        anzm := 8;
     END IF;
     IF coalesce(ksvrecord.ks_ba8, 0) > 0 THEN
        anzm := 9;
     END IF;
     IF coalesce(ksvrecord.ks_ba9, 0) > 0 THEN
        anzm := 10;
     END IF;
     IF coalesce(ksvrecord.ks_ba10, 0) > 0 THEN
        anzm := 11;
     END IF;
     IF coalesce(ksvrecord.ks_ba11, 0) > 0 THEN
        anzm := 12;
     END IF;
     IF coalesce(ksvrecord.ks_ba12, 0) > 0 THEN
        anzm := 13;
     END IF;
     IF coalesce(ksvrecord.ks_ba13, 0) > 0 THEN
        anzm := 14;
     END IF;
     IF coalesce(ksvrecord.ks_ba14, 0) > 0 THEN
        anzm := 15;
     END IF;
     IF coalesce(ksvrecord.ks_ba15, 0) > 0 THEN
        anzm := 16;
     END IF;
     IF coalesce(ksvrecord.ks_ba16, 0) > 0 THEN
        anzm := 17;
     END IF;
     IF coalesce(ksvrecord.ks_ba17, 0) > 0 THEN
        anzm := 18;
     END IF;
     IF coalesce(ksvrecord.ks_ba18, 0) > 0 THEN
        anzm := 19;
     END IF;
     IF coalesce(ksvrecord.ks_ba19, 0) > 0 THEN
        anzm := 20;
     END IF;

     RETURN anzm;
    END $$ LANGUAGE plpgsql STABLE;

--Subkostenstellen bzw Arbeitsplätze zur Hauptkostelle ausweisen
CREATE OR REPLACE FUNCTION tplanterm.ks_get_allsubks(IN oks VARCHAR, OUT ks VARCHAR) RETURNS SETOF VARCHAR AS $$
 DECLARE r RECORD;
 BEGIN
  SELECT * INTO r FROM ksv WHERE ks_abt=oks;
  IF r.ks_planpool THEN --POOL
     ks := oks || ' |0';
     RETURN NEXT;
  END IF;
  IF r.ks_ba > 0 THEN --Arbeitsplatz 1/Stammarbeistplatz HAT KEINEN ZUSATZ
     ks := oks;
     RETURN NEXT;
  END IF;
  IF r.ks_ba1 > 0 THEN --Arbeitsplatz 2
     ks := oks || ' /2';
     RETURN NEXT;
  END IF;
  IF r.ks_ba2 > 0 THEN --Arbeitsplatz 3
     ks := oks || ' /3';
     RETURN NEXT;
  END IF;
  IF r.ks_ba3 > 0 THEN --Arbeitsplatz 4
     ks := oks || ' /4';
     RETURN NEXT;
  END IF;
  IF r.ks_ba4 > 0 THEN --Arbeitsplatz 5
     ks := oks || ' /5';
     RETURN NEXT;
  END IF;
  IF r.ks_ba5 > 0 THEN --Arbeitsplatz 6
     ks := oks || ' /6';
     RETURN NEXT;
  END IF;
  IF r.ks_ba6 > 0 THEN --Arbeitsplatz 7
     ks := oks || ' /7';
     RETURN NEXT;
  END IF;
  IF r.ks_ba7 > 0 THEN --Arbeitsplatz 8
     ks := oks || ' /8';
     RETURN NEXT;
  END IF;
  IF r.ks_ba8 > 0 THEN --Arbeitsplatz 9
     ks := oks || ' /9';
     RETURN NEXT;
  END IF;
  IF r.ks_ba9 > 0 THEN --Arbeitsplatz 10
     ks := oks || ' /10';
     RETURN NEXT;
  END IF;
  IF r.ks_ba10 > 0 THEN --Arbeitsplatz 11
     ks := oks || ' /11';
     RETURN NEXT;
  END IF;
  IF r.ks_ba11 > 0 THEN --Arbeitsplatz 12
     ks := oks || ' /12';
     RETURN NEXT;
  END IF;
  IF r.ks_ba12 > 0 THEN --Arbeitsplatz 13
     ks := oks || ' /13';
     RETURN NEXT;
  END IF;
  IF r.ks_ba13 > 0 THEN --Arbeitsplatz 14
     ks := oks || ' /14';
     RETURN NEXT;
  END IF;
  IF r.ks_ba14 > 0 THEN --Arbeitsplatz 15
     ks := oks || ' /15';
     RETURN NEXT;
  END IF;
  IF r.ks_ba15 > 0 THEN --Arbeitsplatz 16
     ks := oks || ' /16';
     RETURN NEXT;
  END IF;
  IF r.ks_ba16 > 0 THEN --Arbeitsplatz 17
     ks := oks || ' /17';
     RETURN NEXT;
  END IF;
  IF r.ks_ba17 > 0 THEN --Arbeitsplatz 18
     ks := oks || ' /18';
     RETURN NEXT;
  END IF;
  IF r.ks_ba18 > 0 THEN --Arbeitsplatz 19
     ks := oks || ' /19';
     RETURN NEXT;
  END IF;
  IF r.ks_ba19 > 0 THEN --Arbeitsplatz 20
     ks := oks || ' /20';
     RETURN NEXT;
  END IF;
  RETURN;
END $$ LANGUAGE plpgsql;


--Kostenstellenkapazität eines Tages ermitteln
--Berücksichtigung Maschinenausfälle geplant (maschausf)
SELECT tsystem.function__drop_by_regex( 'ks_day_kapa', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.ks_day_kapa(
    IN oks varchar,
    IN ks varchar,
    IN do_date date,
    IN EXCEPTION_IF_NO_KAPA bool DEFAULT TRUE,
    IN  _check_wkst_kapbelast boolean = true -- das wird nur false wenn die Plantafel-Funktion Woche basierend das bereits gechecked hat: wkst_ksview_kskapa. Bissl Murx
    )
    RETURNS numeric
    AS $$
    DECLARE
      ksvrecord record;
      kapa      numeric;
      dayofweek integer;
      S         varchar;
      ba        numeric(5,3);
      --
      kapaz_mo  numeric;
      kapaz_di  numeric;
      kapaz_mi  numeric;
      kapaz_do  numeric;
      kapaz_fr  numeric;
      kapaz_sa  numeric;
      kapaz_so  numeric;
      mausf     numeric;
      mcntid    varchar;
    BEGIN
        --die Daten der Kostenstelle laden!
        SELECT * FROM ksv INTO ksvrecord WHERE ks_abt = oks;
        IF ksvrecord.ks_ausw THEN
          RETURN 0;--auswärtsbearbeitung
        END IF;
        --
        --

        kapa := null;
        dayofweek := day_of_week(do_date);

        -- überschriebene Kapa aus Plantafel
        IF _check_wkst_kapbelast THEN -- das ist false, wenn die PT selbst bereits wochenbasiert die Kapa abruft. Dann würden wir hier gar nicht landen, wenn es für die Woche ne überschriebene Kapa gäbe.
            SELECT wb_kapa_mo, wb_kapa_di, wb_kapa_mi, wb_kapa_do, wb_kapa_fr, wb_kapa_sa, wb_kapa_so, wb_ks
              INTO kapaz_mo, kapaz_di, kapaz_mi, kapaz_do, kapaz_fr, kapaz_sa, kapaz_so, S
              FROM wkst_kapbelast
             WHERE wb_oks = oks
               AND wb_ks = ks
               AND wb_week = termweek(do_date)
            ;--wir holen uns die Kapazität falls diese vom Nutzer gesetzt wurde

            --falls überschriebene kapazität, nehmen wir diese vom Tag und ziehen den maschaus ab und geben die Tageskapa zurück
            IF kapaz_mo IS NOT NULL AND dayofweek = 1 THEN kapa := kapaz_mo; END IF;
            IF kapaz_di IS NOT NULL AND dayofweek = 2 THEN kapa := kapaz_di; END IF;
            IF kapaz_mi IS NOT NULL AND dayofweek = 3 THEN kapa := kapaz_mi; END IF;
            IF kapaz_do IS NOT NULL AND dayofweek = 4 THEN kapa := kapaz_do; END IF;
            IF kapaz_fr IS NOT NULL AND dayofweek = 5 THEN kapa := kapaz_fr; END IF;
            IF kapaz_sa IS NOT NULL AND dayofweek = 6 THEN kapa := kapaz_sa; END IF;
            IF kapaz_so IS NOT NULL AND dayofweek = 0 THEN kapa := kapaz_so; END IF;
            --
        END IF;

        -- Tag hat in Woche KEINE überschriebe Kapazität
        IF kapa IS null THEN
            -- Kapa an Freiertagen ist 0, falls es keine Überschreibung der Kapa gab.
            IF EXISTS(SELECT true FROM feiertag WHERE ft_date=do_date) THEN
                RETURN 0;
            END IF;
            -- hat diese KS überhaupt ne Kapa??? (Mo-So)
            IF  coalesce(ksvrecord.ks_ka1, 0)
              + coalesce(ksvrecord.ks_ka2, 0)
              + coalesce(ksvrecord.ks_ka3, 0)
              + coalesce(ksvrecord.ks_ka4, 0)
              + coalesce(ksvrecord.ks_ka5, 0)
              + coalesce(ksvrecord.ks_ka6, 0)
              + coalesce(ksvrecord.ks_ka7, 0) = 0
            THEN
              IF EXCEPTION_IF_NO_KAPA THEN
                RAISE EXCEPTION '%', Format(lang_text(29150) /*'Kostenstelle hat keine Kapazitaet: % : %'*/, KS, ksvrecord.ks_abt);--Kostenstelle hat keine Kapazität
              END IF;
              RETURN 0;
            END IF;
            --

            ba := ksvrecord.ks_ba;--Anzahl Arbeitsplätze Maschine 1;
            -- Anzahl Arbeitsplätze dieser (Sub) Kostenstelle ermitteln
            mcntid := RIGHT(ks, 3);
            IF (SUBSTRING(mcntid, 1, 1) = '/') THEN
          CASE
            WHEN mcntid = '/20' THEN ba := ksvrecord.ks_ba19;
            WHEN mcntid = '/19' THEN ba := ksvrecord.ks_ba18;
            WHEN mcntid = '/18' THEN ba := ksvrecord.ks_ba17;
            WHEN mcntid = '/17' THEN ba := ksvrecord.ks_ba16;
            WHEN mcntid = '/16' THEN ba := ksvrecord.ks_ba15;
            WHEN mcntid = '/15' THEN ba := ksvrecord.ks_ba14;
            WHEN mcntid = '/14' THEN ba := ksvrecord.ks_ba13;
            WHEN mcntid = '/13' THEN ba := ksvrecord.ks_ba12;
            WHEN mcntid = '/12' THEN ba := ksvrecord.ks_ba11;
            WHEN mcntid = '/11' THEN ba := ksvrecord.ks_ba10;
            WHEN mcntid = '/10' THEN ba := ksvrecord.ks_ba9;
            ELSE NULL;
          END CASE;
            ELSE
          mcntid := RIGHT(ks, 2);
          IF (SUBSTRING(mcntid, 1, 1) = '/') THEN
            CASE
              WHEN mcntid = '/9' THEN ba := ksvrecord.ks_ba8;
              WHEN mcntid = '/8' THEN ba := ksvrecord.ks_ba7;
              WHEN mcntid = '/7' THEN ba := ksvrecord.ks_ba6;
              WHEN mcntid = '/6' THEN ba := ksvrecord.ks_ba5;
              WHEN mcntid = '/5' THEN ba := ksvrecord.ks_ba4;
              WHEN mcntid = '/4' THEN ba := ksvrecord.ks_ba3;
              WHEN mcntid = '/3' THEN ba := ksvrecord.ks_ba2;
              WHEN mcntid = '/2' THEN ba := ksvrecord.ks_ba1;
              ELSE NULL;
            END CASE;
          END IF;
            END IF;
            -- Ende Anzahl Arbeitsplätz

            -- Auftragspool hält die Komplettkapazität TODO DROP?! Pool not here any more!
            IF RIGHT(ks, 2) = '|0' THEN
            ba :=   coalesce(ksvrecord.ks_ba  , 0)
              + coalesce(ksvrecord.ks_ba1 , 0)
              + coalesce(ksvrecord.ks_ba2 , 0)
              + coalesce(ksvrecord.ks_ba3 , 0)
              + coalesce(ksvrecord.ks_ba4 , 0)
              + coalesce(ksvrecord.ks_ba5 , 0)
              + coalesce(ksvrecord.ks_ba6 , 0)
              + coalesce(ksvrecord.ks_ba7 , 0)
              + coalesce(ksvrecord.ks_ba8 , 0)
              + coalesce(ksvrecord.ks_ba9 , 0)
              + coalesce(ksvrecord.ks_ba10, 0)
              + coalesce(ksvrecord.ks_ba11, 0)
              + coalesce(ksvrecord.ks_ba12, 0)
              + coalesce(ksvrecord.ks_ba13, 0)
              + coalesce(ksvrecord.ks_ba14, 0)
              + coalesce(ksvrecord.ks_ba15, 0)
              + coalesce(ksvrecord.ks_ba16, 0)
              + coalesce(ksvrecord.ks_ba17, 0)
              + coalesce(ksvrecord.ks_ba18, 0)
              + coalesce(ksvrecord.ks_ba19, 0)
              ;
            END IF;

            IF    dayofweek = 0 THEN kapa := ksvrecord.ks_ka1; -- sonntag
            ELSIF dayofweek = 1 THEN kapa := ksvrecord.ks_ka2; -- montag
            ELSIF dayofweek = 2 THEN kapa := ksvrecord.ks_ka3; -- dienstag
            ELSIF dayofweek = 3 THEN kapa := ksvrecord.ks_ka4; -- mittwoch
            ELSIF dayofweek = 4 THEN kapa := ksvrecord.ks_ka5; -- donnerstag
            ELSIF dayofweek = 5 THEN kapa := ksvrecord.ks_ka6; -- freitag
            ELSIF dayofweek = 6 THEN kapa := ksvrecord.ks_ka7; -- samstag
            END IF;

            kapa := kapa * ba * (ksvrecord.ks_kf / 100); -- tageskapa * anzahl Arbeitsplätze auf entsprechender Maschine * Korrekturfaktor

        END IF;

        -- Maschinenausfall berücksichtigen
        -- Berechnung in eigene Funktion ausgelagert, da performanter.
        mausf := coalesce( maschausf__calc__ma_efftime__by__ks_abt__and__date( _ks_abt => oks, _date => do_date ), 0 );

        RETURN greatest( 0, kapa - mausf ); -- Keine negative Tageskapazität zulassen.
    END $$ LANGUAGE plpgsql STABLE;

-- Tageskapazität einer KSVBA-Ressource ermitteln.
CREATE OR REPLACE FUNCTION tplanterm.ks_day_kapa(
    IN _resource_id int,
    IN _date date,
    IN EXCEPTION_IF_NO_KAPA bool DEFAULT TRUE
    )
    RETURNS numeric
    AS $$

      SELECT tplanterm.ks_day_kapa(
                oks                   => k.ksb_ks_abt,
                ks                    => k.ksb_ks_shorthand,
                do_date               => _date,
                EXCEPTION_IF_NO_KAPA  => EXCEPTION_IF_NO_KAPA
             )
        FROM scheduling.resource__translate__resource_id__to__ksvba__shorthand( _resource_id ) k

    $$ LANGUAGE SQL STABLE;

--Ermitteln der Kostenstellenkapazität der Woche auf basis von ks_day_kapa; Mögliche Kapazität pro Woche
--Gibt die Wochenkapaztität zurück. Bei laufenden Wochen nur die Tage, welche noch in der Zukunft liegen. Wenn wegkapa=TRUE, dann wird zurückgegeben, wieviel Kapazität bereits verbraucht wurde.
SELECT tsystem.function__drop_by_regex( 'wkst_ks_week_kapa', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.wkst_ks_week_kapa(
    IN  ks varchar,
    IN  oks varchar,
    IN  yearWeek varchar,
    IN  wegkapa boolean,
    IN  _internal_current_date timestamp = current_date,
    IN  _check_wkst_kapbelast boolean = true -- das wird nur false wenn die Plantafel-Funktion Woche basierend das bereits gechecked hat: wkst_ksview_kskapa. Bissl Murx
    )
    RETURNS numeric(12,2)
    AS $$
    DECLARE
        _startDay date;
        _i integer;
        _k numeric;
        _sum numeric;
    BEGIN
        --Erstes Datum der durch "YYYYWW" angegebenen Woche ermitteln
        _startDay := to_timestamp(yearWeek,'IYYYIW')::date;
        _sum := 0;
        --Aufsummieren über Kapazitäten der Wochentage
        FOR _i IN 0..6 LOOP
            IF coalesce(wegkapa, false) THEN -- die bereits abgelaufene Kapazität der Kostenstelle ermitteln
               IF _startDay + _i < _internal_current_date::date THEN -- ansonsten sind wir in der vergangenheit, keine Kapazität mehr vorhanden
                   _sum := _sum + coalesce(_k, tplanterm.ks_day_kapa(oks, ks, _startDay + _i, false, _check_wkst_kapbelast));
                   --RAISE NOTICE '-%-%', _startDay+_i, _sum;
               END IF;
            ELSE
               IF _startDay+_i >= _internal_current_date::date THEN--ansonsten sind wir in der vergangenheit, keine Kapazität mehr vorhanden
                   _sum := _sum + coalesce(_k, tplanterm.ks_day_kapa(oks, ks, _startDay + _i, false, _check_wkst_kapbelast));
                   --RAISE NOTICE '%-%', _startDay+_i, _sum;
               END IF;
            END IF;
        END LOOP;
        --
        RETURN _sum;
    END $$ LANGUAGE plpgsql STABLE;


--Ermitteln Kostenstellenkapazität auf Basis von day_kapa und ks_week_kapa
--Verbrauchte Kapazität wird abgezogen (wkst_kapbelast)
--Ergebnis = MöglicheKapazität (tplanterm.wkst_ks_week_kapa) - Belastung (wkst_kapbelast)
SELECT tsystem.function__drop_by_regex( 'wkst_ksview_kskapa', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.wkst_ksview_kskapa(
    IN  ks varchar,
    IN  oks varchar,
    IN  week varchar,
    IN  _internal_current_date TIMESTAMP = current_date
    )
    RETURNS numeric
    AS $$
    DECLARE
        kapa     numeric;
        kapaz_mo numeric;
        kapaz_di numeric;
        kapaz_mi numeric;
        kapaz_do numeric;
        kapaz_fr numeric;
        kapaz_sa numeric;
        kapaz_so NUMERIC;
        daynum   integer;
        S varchar;
        r record;
    BEGIN
        IF ks_ausw FROM ksv WHERE ks_abt = oks THEN
            RETURN 0;
        END IF;
        --
        IF ks LIKE '%|0' THEN --Poolkostenstelle: es gibt nur Einschränkungen der Unterkostenstelle. Die Poolkostenstelle selbst kann keine Stundeneinschränkungen erhalten
          IF NOT EXISTS(SELECT true FROM wkst_kapbelast WHERE wb_ks=ks AND wb_week=week) THEN --Kreyenberg: um ks_top_ksabt zu planen, benötigen wir auch von Pools die Belastung. Daher auch anlegen
             INSERT INTO wkst_kapbelast (wb_ks, wb_oks, wb_week) VALUES (ks, oks, week);--eintragen in die Belastungs-Tabelle
          END IF;
          RETURN SUM(tplanterm.wkst_ksview_kskapa(ks_get_allsubks, oks, week)) FROM tplanterm.ks_get_allsubks(oks) WHERE ks_get_allsubks NOT LIKE '%|0';
        ELSE
          SELECT wb_kapa_mo, wb_kapa_di, wb_kapa_mi, wb_kapa_do, wb_kapa_fr, wb_kapa_sa, wb_kapa_so, wb_ks
            INTO kapaz_mo, kapaz_di, kapaz_mi, kapaz_do, kapaz_fr, kapaz_sa, kapaz_so, S
            FROM wkst_kapbelast
           WHERE wb_ks = ks
             AND wb_week = week;--wir holen uns die Kapazität falls diese vom Nutzer gesetzt wurde

          IF S IS NULL THEN--wir haben noch keinen Eintrag für diese KS in dieser Woche
              INSERT INTO wkst_kapbelast (wb_ks, wb_oks, wb_week) VALUES (ks, oks, week);--eintragen in die Belastungs-Tabelle
          END IF;
        END IF;

        -- dies ist nur eine Abkürzung, wir wissen bereits das die Woche überschriebene Kapazitäten hat. Dann nehmen wir direkt das Ergebnis dieser anstatt in wkst_ks_week_kapa > wkst_ks_week_kapa dann pro Tag der Woche dies auszuwerten
        IF   kapaz_mo IS NOT NULL
          OR kapaz_di IS NOT NULL
          OR kapaz_mi IS NOT NULL
          OR kapaz_do IS NOT NULL
          OR kapaz_fr IS NOT NULL
          OR kapaz_sa IS NOT NULL
          OR kapaz_so IS NOT NULL
        THEN--wir haben an mindestens einem Tag eine überschriebene Kapazität
           IF termweek(_internal_current_date) = week THEN--aktuelle Woche
               SELECT EXTRACT(dow from _internal_current_date) INTO daynum;
               kapa := 0;
               IF DayNum = 1 THEN
                   kapa := kapa + kapaz_mo + kapaz_di + kapaz_mi + kapaz_do + kapaz_fr + kapaz_sa + kapaz_so;
               END IF;
               IF DayNum = 2 THEN
                   kapa := kapa + kapaz_di + kapaz_mi + kapaz_do + kapaz_fr + kapaz_sa + kapaz_so;
               END IF;
               IF DayNum = 3 THEN
                   kapa := kapa + kapaz_mi + kapaz_do + kapaz_fr + kapaz_sa + kapaz_so;
               END IF;
               IF DayNum = 4 THEN
                   kapa := kapa + kapaz_do + kapaz_fr + kapaz_sa + kapaz_so;
               END IF;
               IF DayNum = 5 THEN
                   kapa := kapa + kapaz_fr + kapaz_sa + kapaz_so;
               END IF;
               IF DayNum = 6 THEN
                   kapa := kapa + kapaz_sa + kapaz_so;
               END IF;
               IF DayNum = 0 THEN
                   kapa := kapa + kapaz_so;
               END IF;
               RETURN kapa;
           ELSIF termweek(_internal_current_date) > week THEN--aktuelle oder vergangene Woche
               RETURN 0;--woche ist vergangen, keine Kapa (dürfte eigentlich nie aufgerufen werden
           ELSE--zukünftige woche
               kapa := kapaz_mo + kapaz_di + kapaz_mi + kapaz_do + kapaz_fr + kapaz_sa + kapaz_so;--gesamt angegebene Kapazität ist verfügbar
               --
               RETURN kapa;
           END IF;--is not null
        ELSE
           --wir ermitteln die Kapazität aus den Stammdaten. Feiertage werden da bereits berücksichtigt!
           kapa := tplanterm.wkst_ks_week_kapa(ks, oks, week, FALSE, _internal_current_date, _check_wkst_kapbelast => false);

           RETURN kapa;
        END IF;
    END $$ LANGUAGE plpgsql;
--

/* Diese Archivierung der Funktion tplanterm.get_ksview() kann gelöscht werden, wenn alle stellen, wo diese Funktion gerufen wird ersetzt wurden. */
-- SELECT tsystem.function__drop_by_regex( 'get_ksview', 'tplanterm', _commit => true );
-- CREATE OR REPLACE FUNCTION tplanterm.get_ksview(

--     IN ks VARCHAR,      -- entspricht ksb_ks_shorthand
--     IN oks VARCHAR,     -- entspricht ks_abt
--     IN planauftg BOOL,
--     IN onlyplanauftg BOOL,
--     IN onlyix INTEGER,
--     IN _startdate date = today(),

--     OUT key VARCHAR,
--     OUT week INTEGER,
--     OUT weekday VARCHAR,
--     OUT pos INTEGER,
--     OUT a2id INTEGER,
--     OUT tbedarf NUMERIC,
--     OUT otbedarf NUMERIC,
--     OUT maschautota NUMERIC,
--     OUT kapaz NUMERIC,
--     OUT vabg_ende BOOLEAN,
--     OUT vabg_ausw BOOLEAN,
--     OUT splitt BOOLEAN,
--     OUT a2wid INTEGER

--  ) RETURNS SETOF RECORD AS $$
--  DECLARE r RECORD;
--      firstdayofweek DATE;
--      WeekEndKorr INTEGER;--ab Samstag neue Woche, wenn ein Planer Samstag kommt, plant er für die Folgewoche
--      I Integer;
--      I1 Integer;
--      stempz NUMERIC;
--      N Numeric;
--      weekkapa NUMERIC;
--      wegkapa NUMERIC;
--      planweekkapa NUMERIC;
--      abgweeks Integer;
--      rechbedarf NUMERIC;
--      wslots Integer[100];
--      P Integer;
--      userbedarf NUMERIC;
--      kapazday NUMERIC;
--      tofstemp NUMERIC;
--      eweek Integer;
--      weekbelast NUMERIC[50];
--      planpool BOOLEAN;
--      isadmin BOOLEAN;
--      numweeks INTEGER;
--      _currentdate date;
--  BEGIN

--     IF ( select tsystem.settings__getbool( 'pt.use_new_time_as_datasource_' || current_user, false ) ) THEN

--       -- return data;
--       RETURN QUERY select * from tplanterm.resource_timeline__planterm_view__fetch( ks, oks, onlyix, now()::timestamp );

--       -- quit
--       RETURN;
--     END IF;

--    _currentdate := _startdate;

--    numweeks:=IfThen(TSystem.Settings__GetBool('Plant_80WochenAnsicht_' || current_user), 80, 31);

--    For I in 0..100 Loop
--      wslots[I]:=0;
--    END Loop;

--    SELECT true INTO isadmin FROM pg_group, pg_user WHERE groname IN ('SYS.PT.Plantafel-Admin', 'SYS.PT.Plantafel-Worker') AND usesysid=ANY(grolist) AND usename=current_user;

--    isadmin:=COALESCE(isadmin, false);
--    --

--    FOR I IN 0..numweeks LOOP
--      weekbelast[I]:=0;
--    END LOOP;

--    --
--    FOR I IN 0..numweeks LOOP--kommenden 3 Monate (20 Wochen)
--     --starttag für die Woche ermitteln
--     IF I=0 then--aktuelle Woche, aktueller Tag beginnt
--      firstdayofweek:=_currentdate;
--     ELSIF I=1 THEN
--      --wir ermitteln den ersten tag dieser Woche, damit folgewochen richtig berechnet werden
--      firstdayofweek:=_currentdate - CAST(EXTRACT(dow from _currentdate) AS INTEGER)+1;--wegen sonntagszählung
--     END IF;
--     --
--     IF extract(dow FROM _currentdate) = 0 THEN --Sonntags
--        WeekEndKorr := 1;
--     ELSIF extract(dow FROM _currentdate) = 6 THEN --Samstag
--        WeekEndKorr := 2;
--     ELSE
--        WeekEndKorr := 0;
--     END IF;
--     --
--     week := CAST(week_of_year(_currentdate + WeekEndKorr + I * 7) AS INTEGER);
--     weekday := week;
--     --
--     pos := 0;
--     I1 := 0;
--     IF NOT (SELECT ks_planinfo FROM ksv WHERE ks_abt = oks) THEN --kapazizät der kostenstelle ermitteln in dieser woche
--      kapaz := tplanterm.wkst_ksview_kskapa(ks, oks, CAST(week AS VARCHAR));
--      planweekkapa:=kapaz;
--      IF (I=0) AND (ks NOT LIKE '%|0') then--aktuelle Woche, heute gestempelte Zeit abziehenl, im mom nur wenn Einzelmaschine
--          --IF (SELECT ks_ba1 FROM ksv WHERE ks_abt=oks) =0 then
--              stempz:=Round(SUM(COALESCE(ba_efftime, timediff(ba_anf, CAST(now() AS TIMESTAMP(0) WITHOUT TIME ZONE))))) FROM bdea WHERE timestamp_to_date(ba_anf) = _currentdate AND ba_ks=oks AND ba_ix||'~'||ba_op IN (SELECT a2_ab_ix||'~'||a2_n FROM ab2_wkstplan JOIN ab2 ON a2_id=a2w_a2_id WHERE a2w_oks=oks AND a2w_ks=ks AND a2w_planweek=week);
--              n:=tplanterm.ks_day_kapa(oks, ks, _currentdate);
--              If COALESCE(stempz,0)>n THEN
--                  --mehr Zeit gestempelt als für diesen tag geplant (Überzeit), dann nur die Tageplankapa in der Plantafel ausbuchen
--                  stempz:=n;
--              END IF;
--              kapaz:=kapaz-COALESCE(stempz,0);
--          --End If;
--      END If;
--     ELSE
--      planweekkapa:=1;
--      kapaz:=1;
--     END IF;
--     --
--     If planweekkapa=0 then
--      planweekkapa:=1;
--     End If;
--     weekkapa:=kapaz;
--     wegkapa:=0;
--     splitt:=False;
--     a2wid:=NULL;
--     --
--     IF current_user='root' THEN--log/debug
--          --RAISE NOTICE 'start auftg ks: %, week: %, i%, time: %', ks, week, I, CAST(currenttime() AS TIME);
--     END IF;
--     --alle Aufträge in der angegebenen Woche
--     --inweekDay_:=NULL;--Wochentagszähler zurücksetzen für neue Woche!
--     FOR r IN SELECT a2w_prio, a2_at, a2w_id, a2_id, a2_ab_ix, a2_n,
--                     a2_tr, a2_ta, a2_time_stemp, a2_time_stemp__ruest_overlap, a2w_stukorr,
--                     a2w_oks AS a2_ks,
--                     a2w_planweek, a2w_endweek, a2w_pat, a2w_pat, a2w_pet,
--                     a2w_marked, a2_ausw, ks_ausw
--           FROM ab2 JOIN ab2_wkstplan ON a2w_a2_id=a2_id JOIN abk ON ab_ix=a2_ab_ix JOIN ksv ON ks_abt=oks
--           WHERE a2w_ks=ks AND a2_interm AND NOT a2w_ende AND NOT a2_ende AND ab_inplantaf AND (NOT ks_planinfo OR a2_ab_ix=COALESCE(onlyix,0))
--           AND
--            (COALESCE(Round(a2_ta,2)-Round(a2_group_ta,2),1)>0)
--           AND
--            CASE WHEN I=0 THEN
--             (COALESCE(a2w_planweek, termweek(a2_at))<=week)--im ersten durchlauf alle rückständigen Aufträge mit zur aktuellen woche nehmen
--            WHEN I=numweeks THEN
--             (COALESCE(a2w_planweek, termweek(a2_at))>=week)--im letzte durchlauf alle restaufträge nehmen
--            ELSE
--             (COALESCE(a2w_planweek, termweek(a2_at))=week)--in den folgedurchläufen immer die Aufträge die auch in die Woche gehören
--            END
--           AND
--            CASE WHEN NOT planauftg THEN --ohne Planaufträge
--             COALESCE(abk.insert_by,'')<>'PLAN'
--            ELSE
--             True
--            END
--           AND
--            CASE WHEN onlyplanauftg THEN --nur Planaufträge
--             COALESCE(abk.insert_by,'')='PLAN'
--            ELSE
--             True
--            END
--           ORDER BY a2w_prio, NOT a2_time_stemp>0, a2_at, a2_ab_ix, a2_n
--        LOOP
--          IF current_user='root' THEN--log/debug
--              RAISE NOTICE 'week: %, time: %', week, CAST(currenttime() AS TIME);
--          END IF;
--          splitt:=r.a2w_marked=-1;
--          a2wid:=r.a2w_id;
--      kapaz:=weekkapa;--wegen der Umstellung der Kapazitäten beim Wochenwechsel, arbeitsgang in mehreren wochen
--      I1:=I1+1;
--      a2id:=r.a2_id;
--      --Vorarbeitsgang auswärts oder beendet
--      SELECT a2_ende, a2_ausw INTO vabg_ende, vabg_ausw FROM ab2 JOIN ksv ON ks_abt=a2_ks WHERE a2_ab_ix=r.a2_ab_ix AND a2_n<r.a2_n AND (ks_plan OR ks_ausw) ORDER BY a2_n DESC LIMIT 1;
--      vabg_ende:=COALESCE(vabg_ende, true);
--      vabg_ausw:=COALESCE(vabg_ausw, false);
--      --wenn erste woche eventuell laufende Stempelung
--      IF I=0 THEN--in Woche 0 die laufenden Stempelungen, also noch nicht abgestempelte BDE datensätze runterrechnen
--          tofstemp:=SUM(timediff(ba_anf, CAST(now() AS TIMESTAMP(0) WITHOUT TIME ZONE))) FROM bdea WHERE ba_end IS NULL AND timestamp_to_date(ba_anf) = _currentdate AND ba_ix=r.a2_ab_ix and ba_op=r.a2_n AND ba_ks=oks AND ba_efftime IS NULL;
--          n:=ROUND(SUM(COALESCE(r_std_sek,0)/3600)) FROM rm WHERE r_a2_id=r.a2_id;
--          IF n<0 THEN n:=0; END IF;--Minus-Rückmeldungen abfangen, das erhöht die Kapazitäten nicht!
--              IF current_user='root' THEN
--                  RAISE NOTICE 'week: %, a2_id: %, tofstemp: %, rm: %', week, r.a2_id, tofstemp, n;
--              END IF;
--          tofstemp:=COALESCE(tofstemp,0)+COALESCE(n,0);
--      ELSE
--          tofstemp:=0;--keine laufende Stempelung
--      END IF;
--      --
--      If splitt THEN
--          -- bei Splitt nicht einfach die gesamte stempelzeit sondern nur die auch auf der KS des Splitt ist abziehen
--          tbedarf := greatest(0,   r.a2w_stukorr
--                                 - bdea__ba_efftime__sum__by__params__get(
--                                              r.a2_ab_ix,
--                                              r.a2_n,
--                                              _ba_ks => oks
--                                   )
--                                 - coalesce(tofstemp, 0)
--                             );
--      ELSE
--          -- normaler arbeitsgang, dann die gesamt stempelzeit runner, problem mit stempelzeit der split denke ich
--          tbedarf := greatest(0, coalesce((  coalesce(r.a2w_stukorr, r.a2_ta, 0)
--                                           - coalesce(r.a2_time_stemp, 0)
--                                           -- zu viel gestempelte Rüstzeit, welche in a2_time_stemp enthalten - und somit abgezogen wird - wieder dazuaddieren
--                                           + CASE WHEN r.a2w_stukorr IS null THEN
--                                                       coalesce(r.a2_time_stemp__ruest_overlap, 0)
--                                                  ELSE -- es wurde eine Manuell überschriebene (Rest) Zeit eingegeben. In der Plantafel Dialog "Auftragszeit anpasse" geht der Bediener davon aus - das er die noch erforderliche Restzeit eingibt. Dann darf kein Magic dazuaddiert werden
--                                                       0
--                                             END
--                                           - coalesce(tofstemp, 0)
--                                           )

--                                           , coalesce(r.a2w_stukorr, r.a2_ta, 0)
--                                          )
--                              );
--      END IF;
--      --
--      IF current_user='root' THEN--debug log
--              RAISE NOTICE 'week: %, a2_id: %, otbedarf: %; kapaz: %', week, r.a2_id, tbedarf, kapaz;
--      END IF;
--      --
--      otbedarf:=tbedarf;
--      rechbedarf:=tbedarf;
--      SELECT a2ws_stu INTO userbedarf FROM ab2_wkstplan_stu WHERE a2ws_a2w_id=a2wid AND a2ws_week=week;
--      --Satz abwerfen; bei Aufträge mit mehr 1 Woche bedarf, mehrere Sätze
--      abgweeks:=0;
--      --
--      IF current_user='root' THEN--log/debug
--              RAISE NOTICE 'tplanterm.get_ksview: startloop week: %, time: %', week, CAST(currenttime() AS TIME);
--       END IF;
--      IF (I<numweeks)AND((Round(rechbedarf)>kapaz)OR(COALESCE(userbedarf,999999)<rechbedarf))AND NOT (r.ks_ausw OR r.a2_ausw)THEN--mehr kapa als die woche hergibt oder wir verwenden weniger als die woche hat
--          IF current_user='root' THEN--debug log
--                  RAISE NOTICE 'Splitt: Ausw/kapaz<bedarf';
--          END IF;
--          WHILE rechbedarf>0 LOOP--pro Woche die der Arbeitsgang braucht einen Satz
--              IF abgweeks>0 THEN--die Wochenkapazität der Anfangswoche haben wir bereits
--                  --wir haben einen Auftrag, welcher in der aktuellen Woche läuft, der aber umbricht auf eine Folgewoche
--                  week:=CAST(week_of_year(_currentdate + WeekEndKorr + (I + abgweeks) * 7) AS INTEGER);
--                  --
--                  kapaz:=tplanterm.wkst_ksview_kskapa(ks, oks, CAST(week AS VARCHAR));
--                  IF abgweeks>100 THEN--endlosschleife, abbrechen durch setzen der kapa auf unendlich
--                     kapaz:=99999;
--                  END IF;
--                  --Kommentieren wieso. Hintergrund: Auftrag aus aktueller Woche bricht in Folgewoche um
--                  If (I=0) THEN--in der aktuellen woche die verbrauchte kapa gleich wieder abziehen
--                      stempz:=Round(SUM(COALESCE(ba_efftime, timediff(ba_anf, CAST(now() AS TIMESTAMP(0) WITHOUT TIME ZONE))))) FROM bdea WHERE timestamp_to_date(ba_anf) = _currentdate AND ba_ks=oks AND ba_ix||'~'||ba_op IN (SELECT a2_ab_ix||'~'||a2_n FROM ab2_wkstplan JOIN ab2 ON a2_id=a2w_a2_id WHERE a2w_oks=oks AND a2w_ks=ks AND a2w_planweek=week);
--                      n:=tplanterm.ks_day_kapa(oks, ks, _currentdate);
--                      If COALESCE(stempz,0)>n THEN
--                          --mehr Zeit gestempelt als für diesen tag geplant (Überzeit), dann nur die Tageplankapa in der Plantafel ausbuchen
--                          stempz:=n;
--                      END IF;
--                      kapaz:=kapaz-COALESCE(stempz,0);
--                  END IF;
--                  --wenn es Aufträge gibt die in die folgewochen reingehen, dann müssen wir in den Folgewochen schon den Slot vormerken
--                  wslots[I+abgweeks]:=wslots[I+abgweeks]+1;--in dieser woche wird ein Slot durch langlaufende AG's blockiert
--              END IF;
--              --Berechnen der Kapaztität --  ********************************************************************
--               SELECT a2ws_stu INTO userbedarf FROM ab2_wkstplan_stu WHERE a2ws_a2w_id=a2wid AND a2ws_week=week;--Bedarf der nächsten Woche
--               --
--               tbedarf:=MIN(COALESCE(userbedarf, rechbedarf), kapaz);--das ist die Kapazität die wir haben in der woche oder brauchen
--               rechbedarf:=rechbedarf-tbedarf;--wir verringern den benötigten bedarf um den gerade vergebenen
--               wegkapa:=wegkapa+tbedarf;
--               weekbelast[I+abgweeks]:=weekbelast[I+abgweeks]+tbedarf;
--              -------------------------      ********************************************************************
--              If abgweeks>0 then --wochenumbruch in folgewoche
--                  P:=Pos;
--                  Pos:=-100+p;
--                  Key:=week||pos||r.a2_id;
--              Else
--                  Pos:=Pos+1;
--                  P:=Pos;
--                  Key:=week||pos;
--              End If;
--              --
--              If I<2 THEN
--                  weekday:=week||'.'||lpad(I1, 2 ,'0');
--              ELSE
--                  weekday:=week;
--              END IF;
--              --
--              RETURN next;
--              Pos:=P;
--              abgweeks:=abgweeks+1;
--          END LOOP;
--          --eintragen der Endwoche bei Aufträgen die länger als 1 Woche brauchen
--          eweek:=week;
--          week:=CAST(week_of_year(_currentdate + WeekEndKorr + I * 7) AS INTEGER);
--          --ursprüngliche Startwoche
--          IF isadmin THEN
--             IF COALESCE(r.a2w_planweek<>week, true) OR COALESCE(r.a2w_endweek, 0)<>eweek OR r.a2w_pat IS NULL OR r.a2w_pet IS NULL THEN--woche hat sich geändert, rückschreiben
--                UPDATE ab2_wkstplan SET a2w_planweek=week, a2w_endweek=eweek, a2w_pat=termweek_to_date(week,true)/*firstdayofweek+WeekEndKorr+I*7*/, a2w_pet=termweek_to_date(eweek)/*firstdayofweek+CAST((I+abgweeks)*7+Round(tbedarf/DO1IF0(planweekkapa*5)) AS INTEGER)*/ WHERE a2w_id=a2wid;
--             END IF;
--          END IF;
--      ELSE--wir haben in der Woche genug kapazität
--          If I=numweeks Then--Folgeaufträge ausserhalb der Woche
--              week:=299999;
--              kapaz:=99999;
--          End If;
--          --
--          --weekbelast:=weekbelast+tbedarf;
--          weekbelast[I]:=weekbelast[I]+tbedarf;
--          --
--          Pos:=Pos+1;
--          Key:=week||Pos;
--          --
--          IF isadmin THEN
--              IF I<numweeks THEN
--                  --start und endwoche eintragen
--                  IF r.ks_ausw OR r.a2_ausw THEN
--                      eweek:=termweek(firstdayofweek+CAST(r.a2_tr AS INTEGER)+CAST(I*7 AS INTEGER)+CAST(r.a2_tr AS INTEGER)/5*2);
--                      IF COALESCE(r.a2w_planweek<>week, true)OR COALESCE(r.a2w_endweek<>eweek, true)OR r.a2w_pat IS NULL OR r.a2w_pet IS NULL THEN--woche hat sich geändert, rückschreiben
--                          UPDATE ab2_wkstplan SET a2w_planweek=week, a2w_endweek=eweek, a2w_pat=termweek_to_date(week,true)/*firstdayofweek+WeekEndKorr+I*7*/, a2w_pet=termweek_to_date(eweek)/*firstdayofweek+WeekEndKorr+CAST(r.a2_tr AS INTEGER)+CAST(I*7 AS INTEGER)*/ WHERE a2w_id=a2wid;
--                      END IF;
--                  ELSE
--                      IF COALESCE(r.a2w_planweek<>week, true)OR COALESCE(r.a2w_endweek<>week, true)OR r.a2w_pat IS NULL OR r.a2w_pet IS NULL THEN--woche hat sich geändert, rückschreiben
--                          UPDATE ab2_wkstplan SET a2w_planweek=week, a2w_endweek=week, a2w_pat=termweek_to_date(week,true)/*firstdayofweek+WeekEndKorr+I*7*/, a2w_pet=termweek_to_date(eweek)/*firstdayofweek+WeekEndKorr+CAST(I*7+Round(tbedarf/DO1IF0(planweekkapa*5)) AS INTEGER)*/ WHERE a2w_id=a2wid;
--                      END IF;
--                  END IF;
--              END IF;--
--          END IF;
--          --
--          If I<2 THEN
--              weekday:=week||'.'||lpad(I1, 2 ,'0');
--          ELSE
--              weekday:=week;
--          END IF;
--          --
--          RETURN next;--dann wird der Arbeitsgang als 1 Datensatz zurückgegeben
--      END IF;--bedarf verteilen
--      --
--     END LOOP;--alle Aufträge in der Woche
--     --
--     --Eintragen Wochenbelastung, wenn unterschiedlich der bereits eingetragenen
--     UPDATE wkst_kapbelast SET wb_belast=weekbelast[I]
--     WHERE wb_ks=ks AND wb_week=week AND Round(COALESCE(wb_belast,0))<>Round(weekbelast[I]);   --eintragen der wochenbelastung
--     --Woche fixieren
--     -- Grundstatus: wb_weekfixauto=False
--     --  Kostenstelle ks_weekfixauto sagt, ob Woche fixiert oder nicht
--     --  wenn Woche fixiert, setzt Algo beides True oder False in Abhängigkeit Kapa
--     --  => wenn Nutzer den Status Fixiert manuell setzt, ist Status Auto nie gesetzt => wird nie zurückgesetzt (not wb_weekfix)
--     --  => wenn automatisch gesperrt wird, ist Auto gesperrt und beides wird zuürckgesetzt (or wb_weekfixauto)
--     --  => wenn Nutzer nicht will, das Woche geschlossen wird, muß er => Kostenstelle abschalten bzw. geht nicht, neuer Status oder Logik drehen oder NULL
--      UPDATE wkst_kapbelast SET
--          wb_weekfix      = weekkapa<=weekbelast[I], --in Abhängigkeit Auslastung den Status setzen
--          wb_weekfixauto  = weekkapa<=weekbelast[I]  --
--      FROM ksv WHERE wb_ks=ks AND ks_abt=wb_oks AND wb_week=week AND ks_weekfixauto AND ks_plan AND NOT ks_ausw
--           AND (NOT wb_weekfix --Woche ist nicht gesperrt kann aber durch ks_weekfixauto automatisch gesperrt werden
--              OR
--                wb_weekfixauto)--Woche ist durch automatik geschlossen, dann kann sie auch automatisch wieder geöffnet werden
--              ;--wenn automatisch gesetzt war und per hand zurück, dann nicht wieder automatisch setzen!
--     --
--     IF current_user='root' THEN--Log/Debug
--          RAISE NOTICE 'end auftg ks: %, week: %, i%, time: %; tbedarf: %; otbedarf: %; kapaz: %', ks, week, I, CAST(currenttime() AS TIME), tbedarf, otbedarf, kapaz;
--     END IF;
--     --falls die Woche noch nicht durch einen Auftrag dargestellt wurde, dann die woche jetzt leer zurückgeben
--     --IF I<5 THEN--erster Monat hat feste Anzahl Slots
--      a2id:=NULL;
--      vabg_ende:=FALSE;
--      tbedarf:=0;
--      a2wid:=NULL;
--      splitt:=NULL;
--      --Anzahl Slots pro Woche reduzieren/vorgeben
--       --in der ersten Woche 7 Slots mehr anzeigen, ab Mitte der Woche reduzieren
--      If I=0 then
--          i1:=12-I1;--erste Woche 11 Slots
--          If Extract(dow from _currentdate) > 2 THEN -- ab Donnerstag reduzieren wir die Slots in der aktuellen Woche um 2
--              i1:=i1-1;
--          End If;
--          If Extract(dow from _currentdate) > 3 THEN -- ab Donnerstag reduzieren wir die Slots in der aktuellen Woche um 2
--              i1:=i1-2;
--          End If;
--          If Extract(dow from _currentdate) > 4 THEN -- ab Donnerstag reduzieren wir die Slots in der aktuellen Woche um 3
--              i1:=i1-4;
--          End If;
--      End If;
--      --in der zweiten Woche 4 Slots mehr anzeigen
--      If I=1 then
--          i1:=8-wslots[I]-I1;
--      End If;
--      --in der 3ten Woche mur noch wenige slots
--      If I=2 then
--          i1:=6-wslots[I]-I1;
--      End If;
--      --in der 4ten Woche mur noch wenige slots
--      If I>=3 then
--          i1:=4-wslots[I]-I1;
--      End If;
--      --
--      If I>6 then
--          i1:=3;
--      End If;
--      --
--      If I>8 then
--          i1:=0;--nur ein slot
--      End If;
--      --nun die Wochen detailliert darstellen
--      FOR P IN 0..I1 LOOP
--       If Pos<>0 THEN
--           otbedarf:=NULL;
--           tbedarf:=NULL;
--           kapaz:=NULL;
--       END IF;
--       Pos:=Pos+1;
--       Key:=week||Pos;
--       RETURN next;
--      END LOOP;
--     --END IF;
--    END LOOP;

--   RETURN;
--  END $$ LANGUAGE plpgsql;
-- --

/* Tabelle sollte nach auftg erstellt werden (OG)
 -- Planauträge (Plantafel Anzeige TMP Data)
CREATE TABLE auftg_planauftg (
  uteil             BOOLEAN,
  auftgid           TEXT,
  aufdbrid          VARCHAR(100),
  ag_id             INTEGER REFERENCES auftg ON DELETE CASCADE,
  ag_astat          VARCHAR(1),
  ag_nr             VARCHAR(30),
  ag_pos            SMALLINT,
  ag_lkn            VARCHAR(21),
  ak_nr             VARCHAR(40),
  aknr              VARCHAR,
  ak_bez            VARCHAR(100),
  ag_stk            NUMERIC(12,4),
  op_ix             INTEGER,
  term              DATE,
  -- System (tables__generate_missing_fields)
  dbrid             VARCHAR(32) NOT NULL DEFAULT nextval('db_id_seq')
);
*/

-- Funktion für Planaufträge (Plantafel)
CREATE OR REPLACE FUNCTION tplanterm.planauftg(IN stat VARCHAR(1), IN agnr VARCHAR DEFAULT '%', IN agpos VARCHAR DEFAULT '%', OUT agid INTEGER, OUT aknr VARCHAR(100), OUT opix INTEGER, OUT uteil BOOL, OUT aufdbrid VARCHAR(50)) RETURNS SETOF RECORD AS $$
  DECLARE r RECORD;
          r1 RECORD;
          i INTEGER;
  BEGIN
    FOR r IN
        SELECT
          ag_id,
          ag_aknr,
          ag_stk,
          op_ix,
          auftg.dbrid
        FROM auftg
          JOIN art ON ak_nr = ag_aknr AND ak_lag
          LEFT JOIN opl ON op_n = ag_aknr AND op_ix IN (SELECT op_ix FROM opl WHERE op_n = ag_aknr ORDER BY op_standard DESC, op_kalku DESC, op_vi LIMIT 1)
        WHERE ag_astat = stat
          AND ag_nr LIKE COALESCE(agnr, '%')
          AND ag_pos LIKE COALESCE(agpos, '%')
          AND NOT ag_done
          AND ag_stkb=0
          AND ag_nr NOT LIKE 'DB%' AND ag_nr NOT LIKE 'DA%'
          AND NOT EXISTS(SELECT true FROM abk WHERE ab_ap_nr = ag_aknr AND ab_plan_ag_id = ag_id AND TSystem.ENUM_getValue(ab_stat,'PL')) -- noch kein Planauftrag dafür vorhanden
          --NOT ag_isgrobplan
          AND ag_stkb < ag_stk_uf1
          AND ag_datum > current_date-365
    LOOP
        agid:=r.ag_id;
        aufdbrid:=r.dbrid;
        uteil:=false;
        IF current_user='root' THEN
            RAISE NOTICE '%', r.ag_aknr;
        END IF;
        i:=1;

        FOR r1 IN
            SELECT *
            FROM tartikel.stueckl__do_stueckl_list(
                'pauftg'||r.ag_id||'-'||r.ag_aknr,
                r.ag_aknr,
                CAST(Round(r.ag_stk) AS INTEGER)
              )
              JOIN art ON ak_nr=stueckl__do_stueckl_list.stn
              JOIN opl ON op_n=ak_nr AND op_ix IN (SELECT op_ix FROM opl WHERE op_n=ak_nr ORDER BY op_standard DESC, op_kalku DESC, op_vi LIMIT 1)
            ORDER BY r.ag_aknr<>stueckl__do_stueckl_list.stn
        LOOP
            --unterteile zu diesem Artikel
            aknr:=r1.stn;
            opix:=r1.op_ix;
            RETURN NEXT;
            uteil:=TRUE;
            aufdbrid:=r.dbrid||'-'|| i;
            i:=i+1;
        END LOOP;
    END LOOP;
    RETURN;
  END $$ LANGUAGE plpgsql;
--

-- Zeigt im Standard die noch offene Arbeitszeit in Prozent der Gesamtarbeitszeit an.
   -- Wenn keine Zeiten geplant sind, dann auf die Menge schauen
   -- Wenn weder Zeiten noch Mengen geplant und gemeldet sind, dann auf das Verhältnis geplante Arbeitsgänge zu geschlossenen AG schauen
-- Verwendung: Umsatzplanung, irgendeine Liste Hydro
-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Abk
-- #22911 berücksichtige nur geplante Arbeitsgänge (ks_plan) und arbeitsgangspezifische Berechnung ohne Sollzeiten anhand der gemeldeten Mengen
CREATE OR REPLACE FUNCTION tplanterm.abk_proz_fertig(
        IN _abix integer,
        IN _a2_n integer default 0
    ) RETURNS numeric(12,2) AS $$
  DECLARE

    -- das Fertigungssoll,
    --   entweder die für die Fertigung geplante Zeit, oder,
    --   falls keine Fertigungszeit geplant ist, die Fertigungsmenge ohne geplanten Ausschuss
    _soll numeric;

    -- das Fertigungsist
    --   entweder die für die Fertigung der ABK gestempelte Zeit, oder,
    --   falls keine Fertigungszeit geplant ist, die als fertig gestempelten Teile
    _ist numeric;

    -- das Fertigungssoll Hauptzeit + Nebenzeit,
    --   falls keine Fertigungszeit Hauptzeit + Nebenzeit geplant ist, die Fertigungsmenge ohne geplanten Ausschuss
    _soll_th_tn numeric;

    _anz_ba_stk numeric;
    _ab_tablename varchar(100);
    _anz_ab2_all  numeric;
    _anz_ab2_ende numeric;

    _result numeric(12,2);
  BEGIN

    --cache
    SELECT c_resultn INTO _result FROM tcache.function_cache
    WHERE c_funcname='tplanterm.abk_proz_fertig' AND c_param0 = _abix AND c_param1 = _a2_n AND NOT c_dirty;
    IF found THEN
      RETURN _result;
    END IF;

    SELECT
        sum(a2_ta),
        sum( ( a2_th_sek + a2_tn_sek ) * ab_st_uf1 ) / 3600,
        sum( a2_time_stemp ),
        count(a2_id) AS c_all_a2id,
        count(CASE WHEN a2_ende THEN 1 END) AS c_end_a2id,
        (SELECT ab_tablename FROM abk as mainabk WHERE abk.ab_mainabk = mainabk.ab_ix) AS mainabk_tname
      INTO
        _soll,
        _soll_th_tn,
        _ist,
        _anz_ab2_all,
        _anz_ab2_ende,
        _ab_tablename
      FROM ab2
        JOIN ksv ON ks_abt = a2_ks AND NOT ks_notin_prozfunc AND ks_plan
        JOIN abk ON ab_ix = a2_ab_ix
      WHERE
          CASE WHEN _a2_n = 0 THEN
              a2_ab_ix IN (SELECT * FROM tplanterm.get_all_child_abk( _abix ))
          ELSE
              a2_ab_ix = _abix AND a2_n = _a2_n
          END
      GROUP BY 6 LIMIT 1;

    _a2_n := nullif( _a2_n, 0 );

    -- Variable für Ausnahmebehandlung Ausnahme 1 und Ausnahme 2
    IF coalesce( _soll_th_tn, 0 ) <= 0      -- Keine Haupt-/Nebenzeiten geplant?
       OR _ab_tablename = 'anl' THEN        -- Am wahrscheinlichsten bei Projekten, PAL

      _anz_ba_stk := sum( ba_stk ) FROM bdea
      JOIN ksv ON ks_abt = bdea.ba_ks AND ks_plan
      WHERE
          ba_ix = _abix AND ( _a2_n IS null OR ba_op = _a2_n );
    END IF;

    -- Ausnahme 1 : Wenn keine Zeiten geplant sind, dann auf die Menge schauen, um den Fortschritt zu errechnen ~ #18173
    IF coalesce( _soll_th_tn, 0 ) <= 0 THEN -- Keine Haupt-/Nebenzeiten geplant?

      -- Die Fertigung muss jeden Arbeitsgang für jedes zu fertigende Teil umfassen, wenn kein Arbeitsgang angegeben.
      _soll :=   ( SELECT ab_st_uf1 FROM abk WHERE ab_ix = _abix )
               * ( SELECT count(*) FROM ab2 JOIN ksv on ks_abt = a2_ks AND ks_plan WHERE a2_ab_ix = _abix AND ( _a2_n IS null OR a2_n = _a2_n )); -- Verbesserungsmöglichkeit: Arbeitsgänge anhand Vorgabezeit gewichten

      -- Die Istmenge enthält alle gestempelten Mengen der ABK, egal für welchen AG.
      _ist := _anz_ba_stk;
    END IF;

     -- Ausnahme 2 : Wenn weder Zeiten noch Mengen geplant und gemeldet sind, dann auf das Verhältnis geplante Arbeitsgänge zu geschlossenen AG schauen, um den Fortschritt zu errechnen  ~ #20308 PAL
    IF coalesce( _soll_th_tn, 0 ) <= 0             -- Keine Haupt-/Nebenzeiten geplant?
       AND _ab_tablename = 'anl'                   -- Am wahrscheinlichsten bei Projekten, PAL
       AND COALESCE( _anz_ba_stk, 0 ) < 1 THEN     -- es gibt keine gemeldete Stückzahlen

      _soll := _anz_ab2_all; -- Anzahl aller Arbeitsgänge
      _ist := _anz_ab2_ende; -- Anzahl beendeter Arbeitsgänge
    END IF;

    _soll := coalesce( _soll, 0);
    _ist := coalesce( _ist, 0 );

    IF _soll > 0 THEN
      _result := round( _ist * 100 / _soll );
    ELSIF  (_ab_tablename = 'anl' AND _soll = 0 AND _ist = 0 ) THEN
    -- Sonderfall, der vermutlich nicht verwendet werden wird; Menge der root-ABK 0 ist
       -- 'Menge der root-ABK 0' kann man als eindeutiges Kriterium für Checklisten-ABKs verwenden, im Unterschied zu Fertigung Kontext PAL
    -- ohne Vorgabezeiten und Menge wäre ein Projekt sonst sofort abgeschlossen
      _result := 0;
    ELSE
      -- Kein sinnvoller Sollwert? Dann ist die Fertigung ja erledigt.
      _result := 100;
    END IF;

    --cache schreiben
    PERFORM tcache.function_cache_setcache_2param('tplanterm.abk_proz_fertig', _abix, _a2_n, _result);

    RETURN _result;
  END $$ LANGUAGE plpgsql STABLE;
--

--Zeigt die noch offenen AG einer ABK an
--http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Abk
CREATE OR REPLACE FUNCTION tplanterm.abk_offen_ag(
    IN abix integer,
    IN childs boolean DEFAULT TRUE,
    IN AllKS boolean DEFAULT FALSE/*nur PlanKS per Default*/
    )
    RETURNS varchar(500)
    AS $$
    DECLARE
        r record;
        _apstring varchar(30);
        _last_a2_aknr varchar(30);
        _result varchar;
        _aw_ad_krz boolean;
        _hide_a2_aknr boolean;
        _abks integer[];
    BEGIN
        IF abix IS NULL THEN
            RETURN NULL;
        END IF;

        --cache
        SELECT c_resultc INTO _result FROM tcache.function_cache WHERE c_funcname = 'tplanterm.abk_offen_ag'
                                                                   AND c_param0 = abix
                                                                   AND c_param1 = childs::varchar
                                                                   AND c_param2 = AllKS::varchar
                                                                   AND NOT c_dirty;
        IF found THEN
            RETURN _result;
        END IF;
        --end cache

        _aw_ad_krz    := TSystem.Settings__GetBool('tplanterm.abk_offen_ag.aw_ad_krz', True);
        _hide_a2_aknr := TSystem.Settings__GetBool('tplanterm.abk_offen_ag.hide_a2_aknr', False);

        _result := ''; _apstring := ''; _last_a2_aknr := '';

        --- #11040
        IF EXISTS (SELECT true FROM abk WHERE ab_ix = abix AND ab_done) THEN
            _result :=  lang_text(12957); ---'ABK beendet' 'JC closed'; --
        ELSIF NOT EXISTS(SELECT true FROM ab2 WHERE a2_ab_ix = abix) THEN
            _result := lang_text(29369); ---'AG nicht vorhanden' 'OR not existing'; --
        ELSIF NOT EXISTS(SELECT true FROM ab2 WHERE a2_ab_ix = abix AND NOT a2_ende) THEN
            _result := lang_text(12957); ---'AG beendet' 'OR closed'; --
        END IF;


        -- String zusammensetzen: KS1->KS2~AP2.1~AP2.2->KS3~AP3.1->KS1
        -- KS mit -> trennen, AP zur Kostenstelle (wenn vorhanden) mit ~ anfügen.
        -- Nur bei KS-Wechsel neue KS angeben, sonst nur AP mit ~ anfügen, siehe #7149.

        IF _result = '' THEN -- nur anders, wenn geschlossen oder kein AG vorhanden!
          if childs then
            _abks := array_agg(get_all_child_abk) FROM tplanterm.get_all_child_abk(abix);
          ELSE
            _abks := array[abix];
          END IF;


          FOR r IN
            SELECT a2_id, a2_ausw, a2_adkrz, coalesce(a2w_oks, a2_ks) AS x_ks, a2_aknr, lag(coalesce(a2w_oks, a2_ks), 1, '') OVER (ORDER BY a2_ab_ix DESC, a2_n) AS vorgaenger_ks -- Window Function lag mit Offset 1 gibt Vorgänger der KS oder '' zurück
              FROM ab2
                   JOIN ksv ON ks_abt = a2_ks AND (ks_plan OR AllKS)
              LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id
             WHERE NOT a2_ende
               AND a2_ab_ix = any(_abks)
             ORDER BY a2_ab_ix DESC, a2_n
          LOOP
            IF r.a2_aknr = 'AW.EXTERN' OR Equals(_last_a2_aknr, r.a2_aknr) THEN --AW.Extern immer ausblenden, wenn Vor-Arbeitspaket gleich dem aktuellem, dann Vor-AP auch ausblenden
                _apstring := '';
            ELSE
                IF _hide_a2_aknr IS true THEN
                    _apstring := coalesce('~' || r.a2_aknr, '');
                ELSE
                    _apstring := '';
                END IF;
            END IF;
            --
            _last_a2_aknr := r.a2_aknr; -- kann auch Arbeitspaket sein, zB Reinigung. Also Arbeitspaket in AVOR/ABK
            --
            IF r.x_ks <> r.vorgaenger_ks THEN
                IF _result = '' THEN -- 1. KS
                    --_result:= r.a2_ks || _apstring;
                    IF r.a2_ausw AND _aw_ad_krz AND r.a2_adkrz IS NOT NULL THEN
                        _result := '!' || r.a2_adkrz;
                    ELSE
                        _result := r.x_ks || _apstring;
                    END IF;
                ELSE -- KS-Wechsel
                    --_result:= _result || '->' || r.a2_ks || _apstring;
                    IF r.a2_ausw AND _aw_ad_krz AND r.a2_adkrz IS NOT NULL THEN
                        _result := _result || '->' || '!' || r.a2_adkrz;
                    ELSE
                        _result := _result || '->' || r.x_ks || _apstring;
                    END IF;
                END IF;
            ELSE -- kein KS-Wechsel
                _result := _result || _apstring;
            END IF;
          END LOOP;
        END IF;

        --cache schreiben
        PERFORM tcache.function_cache_setcache_3param('tplanterm.abk_offen_ag', abix, childs::varchar, AllKS::varchar, NULL, _result);
        --end cache schreiben

        RETURN _result;
    END $$ LANGUAGE plpgsql STABLE STRICT;
--

--
CREATE OR REPLACE FUNCTION tplanterm.makemonthline(
    IN  _date_start  date,
    IN  _date_finish date
    )
    RETURNS SETOF varchar
    AS $$
    DECLARE
        _dat  date;
        _ym   varchar;
        _mo   varchar;
    BEGIN
        _dat  := _date_start;
        _mo := '';
        WHILE _dat < _date_finish + 1 LOOP
            _ym := year_month( _dat );
            IF _mo <> _ym THEN
               RETURN NEXT _ym;
            END IF;
            _mo := _ym;
            _dat  := _dat + 1;
        END LOOP;

        RETURN;
    END $$ LANGUAGE plpgsql STABLE;




 --PROGNOSE
 --PROGNOSE
 --PROGNOSE
 --PROGNOSE
 --PROGNOSE
 --PROGNOSE
 --PROGNOSE
 --PROGNOSE
 --PROGNOSE




-- PROGNOSE #################################
    DROP FUNCTION IF EXISTS tplanterm.artikel_prognose_remember_parents(VARCHAR, VARCHAR);
    DROP FUNCTION IF EXISTS tplanterm.artikel_prognose_remember_parents(VARCHAR, VARCHAR, numeric);
    DROP FUNCTION IF EXISTS tplanterm.artikel_prognose_remember_parents(VARCHAR, VARCHAR, numeric, integer);

   CREATE OR REPLACE FUNCTION tplanterm.artikel_prognose_remember_parents(_aknr VARCHAR, doaknr VARCHAR, menge NUMERIC, OUT parentstring VARCHAR, OUT parentdlz INTEGER, IN _ebene INTEGER DEFAULT 0) AS $$
     DECLARE ps VARCHAR;
             dl INTEGER;
             r  RECORD;
     BEGIN
      --
      SELECT string_agg(aknr||':'||CAST(stm*menge AS NUMERIC(10,2))||':'||_ebene, ',') INTO parentstring FROM stvtrs WHERE resid='VALID-1-'||_aknr AND id IN (SELECT parent FROM stvtrs WHERE resid='VALID-1-'||_aknr AND aknr=doaknr);
      --
      FOR r IN SELECT aknr, stm, ak_bfr FROM stvtrs JOIN art ON ak_nr=aknr WHERE resid='VALID-1-'||_aknr AND id IN (SELECT parent FROM stvtrs WHERE resid='VALID-1-'||_aknr AND aknr=doaknr) LOOP
        SELECT * INTO ps, dl FROM tplanterm.artikel_prognose_remember_parents(_aknr, r.aknr, menge*r.stm, _ebene+1);
        parentstring:=parentstring||COALESCE(','||ps, '');
        parentdlz:=COALESCE(parentdlz,0)+COALESCE(dl, 0)+r.ak_bfr; --Bechaffungsfrist Kopfartikel natürlich nicht!
      END LOOP;
      RETURN;
     END $$ LANGUAGE plpgsql;




    --Auftrag in Prognoseauftrag überführen
    --zuerst alte Prognose entfernen (identifikation über Auftragsnummer und Position)
    --Stückliste auflösen und zusammenfassen
    --Eintrag in BESTANF
    --Mittels Parent (bap_parent_id) wird die Zusammenordnung erreicht
    --Hauptposition (Verkaufsposition) wird identifiziert über Position "-1"

    --SELECT * FROM bedarf_prognose('360042 D');

    -- FUNCTION tplanterm.artikel_prognose_from_auftg(new auftg) RETURNS BOOL siehe "E.10 auftg.Functions.sql"
    -- FUNCTION tplanterm.artikel_prognose_from_ldsdok(new ldsdok) RETURNS BOOL siehe "F.10 einkauf.Functions.sql"

     CREATE OR REPLACE FUNCTION tplanterm.artikel_prognose_from_auftrag(IN _aknr VARCHAR, IN _menge NUMERIC, IN bapagnr VARCHAR, bapagpos INTEGER, _bedarfdat DATE, IN _ldsaufbanfident VARCHAR, IN agid INTEGER, IN ldid INTEGER, IN lkn VARCHAR) RETURNS BOOL AS $$
      DECLARE r RECORD;
              banf_pid INTEGER;
              Pos INTEGER;
              parentdlz INTEGER;
              s VARCHAR;
      BEGIN
       If _menge<=0 THEN --durch bestellt-geliefert kann negative menge errechnet werden
          RETURN false;
       END IF;
       PERFORM execution_code__disable( _flagname => 'bedarfberech' );
       IF agid IS NULL AND ldid IS NULL THEN --Prognose aus Prognosemodul!
              DELETE FROM bestanfpos WHERE bap_banr=_ldsaufbanfident AND bap_agnr=bapagnr AND bap_agpos=bapagpos AND bap_prognose;
       END IF;--alte Prognosebedarfe weg
       --
       UPDATE bestanftxt SET ba_dat=_bedarfdat WHERE ba_nr=_ldsaufbanfident;--neues Prognosedatum eintragen
       IF NOT FOUND THEN--kein Kopfdatensatz vorhanden => komplett neue Prognose
              INSERT INTO bestanftxt (ba_nr, ba_dat, ba_prognose) VALUES (_ldsaufbanfident, _bedarfdat, true);
       END IF;
       --
       IF NOT EXISTS(SELECT true FROM stvtrs WHERE resid='VALID-1-'||_aknr) THEN
              PERFORM tartikel.stueckl__do_stueckl('VALID-1-'||_aknr, _aknr, 1, true);
       END IF;
       --
       Pos:=0;
       --Statement aus BANF => unit UBestAnforderungStueckliste; => ServSqlStkSUM.TServSql2_ServSqlStkSUM
       FOR r IN SELECT
                      id=0, --Hauptartikel
                      aknr,
                      ak_bez,
                      COALESCE((SELECT m_mgcode FROM artmgc WHERE m_id=COALESCE(stmgc, stv.st_mgc, op6.o6_mce)), ak_standard_mgc) AS mgcode,
                      --
                      SUM(COALESCE(tartikel.me__menge_uf1__in__menge(COALESCE(stmgc, stv.st_mgc, op6.o6_mce), stm), stm)) AS stm,
                      SUM(o6_stkz*(SELECT stm FROM stvtrs s2 WHERE s2.resid=stvtrs.resid AND s2.id=stvtrs.parent AND s2.stv_str_revnr IS NULL)) AS o6_stkz,
                       --
                       o6_lz,
                       o6_bz,
                       o6_hz,
                       o6_zz,
                       ak_bfr
                FROM
                      stvtrs LEFT JOIN stv ON stv.dbrid=stv_dbrid
                              JOIN art ON ak_nr=aknr
                              LEFT JOIN op6 ON o6_id=romat_o6_id
                WHERE resid='VALID-1-'||_aknr
                GROUP BY 1,2,3,4,
                         7,8,9,10,11
                ORDER BY 1 DESC, aknr /*TRUE=-1 FIRST*/ LOOP
              IF Pos=0 THEN
                      INSERT INTO bestanfpos (bap_banr, bap_pos, bap_aknr, bap_menge, bap_mecod, bap_termin, bap_agnr, bap_agpos, bap_prognose, bap_pr_ag_id, bap_pr_ld_id, bap_lkn) VALUES (_ldsaufbanfident, IFTHEN(bapagpos=0/*Bei Auftragsvorschau ist Position im Auftrag, daher Kopf hier mit -1 damit nicht doppelt im Bedarf. Bei Prognose ist Kopf auf Position 0*/, 0, -1), r.aknr, r.stm, r.mgcode, _bedarfdat, bapagnr, bapagpos, true, agid, ldid, lkn) RETURNING bap_id INTO banf_pid;
                      UPDATE bestanfpos SET bap_parent_id=banf_pid WHERE bap_id=banf_pid; --damit das CXGrid die Gruppierung richtig darstellt, geben wir uns selbst mit an.
              ELSE
                      --SELECT array_to_string(array_agg(aknr), ',') INTO s FROM stvtrs WHERE resid='VALID-1-'||_aknr AND id IN (SELECT parent FROM stvtrs WHERE resid='VALID-1-'||_aknr AND aknr=r.aknr);
                      SELECT * INTO s, parentdlz FROM tplanterm.artikel_prognose_remember_parents(_aknr, r.aknr, _menge);
                      INSERT INTO bestanfpos (bap_banr, bap_pos, bap_parent_id, bap_aknr, bap_menge, bap_mecod, bap_termin, bap_agnr, bap_agpos, bap_prognose, bap_pr_ag_id, bap_pr_ld_id, bap_txt, bap_lkn) VALUES (_ldsaufbanfident, Pos, banf_pid, r.aknr, r.stm, r.mgcode, timediff_substdays(_bedarfdat, parentdlz, true), bapagnr, bapagpos, true, agid, ldid, s, lkn);
              END IF;
              Pos:=Pos+1;
       END LOOP;
       --
       UPDATE bestanfpos SET bap_menge=_menge WHERE bap_id=banf_pid;
       --
       PERFORM execution_code__enable( _flagname => 'bedarfberech' );
       PERFORM do_artikel_bedarf();
       --
       RETURN true;
       --
      END $$ LANGUAGE plpgsql;
     --



     CREATE OR REPLACE FUNCTION tartikel.bedarf_prognose_termin_frombanf(bap_termin DATE) RETURNS DATE AS $$
      BEGIN
       RETURN CASE WHEN bap_termin<today() THEN
               GREATEST(CAST(date_to_yearmonth(today())||'01' AS DATE), today())/*'000000'*/ /*Rückstand*/
              ELSE
               --GREATEST(/*CAST(date_to_yearmonth(bap_termin)||'01' AS DATE)*/bap_termin, today())
               --CAST(date_to_yearmonth(bap_termin)||'01' AS DATE)
               bap_termin
              END;
      END $$ LANGUAGE plpgsql STABLE;

      CREATE OR REPLACE FUNCTION tartikel.bedarf_prognose(IN aknr VARCHAR, debugmessages BOOL DEFAULT FALSE, debug BOOL DEFAULT FALSE) RETURNS SETOF tartikel.bedarf_prognose_returntype AS $$
        DECLARE r tartikel.bedarf_prognose_returntype;--bedarf_prognose_selecttype;
                result tartikel.bedarf_prognose_returntype;
                r1 RECORD;
                r2 RECORD;
                akbfr INTEGER;
                pos INTEGER;
                bapid INTEGER;
                bapagid INTEGER;
                bapposisparent BOOLEAN;
                bapmenge NUMERIC(19,6);
                lastmonth VARCHAR;
                datumbestand NUMERIC(19,6);
                vbestand NUMERIC(19,6);
                vbzuab NUMERIC(19,6);
                vprozmenge NUMERIC(19,6);
        BEGIN
         pos:=0;
         FOR r IN
                (SELECT 40,  -- Banf werden nach Bestellungen und Aufträgen einsortiert (wenn die am gleichen Tag Bedarf verursachen)
                        tartikel.bedarf_prognose_termin_frombanf(
                            coalesce(bap_termin,
                                     termweek_to_date(bap_termweek)
                                    )
                            ) AS date,
                        date_to_yearmonth(
                            tartikel.bedarf_prognose_termin_frombanf(
                                coalesce(bap_termin,
                                         termweek_to_date(bap_termweek)
                                )
                            )
                            ) AS dateym,

                        bap_menge AS menge,
                        CASE WHEN bap_pr_ag_id ISNULL AND bap_pr_ld_id ISNULL
                             THEN 0
                             WHEN bap_pr_ag_id IS NOT NULL
                             THEN 1
                             ELSE 2
                        END AS ptyp,
                        --0=Prognose, 1=Realauftrag, 2=ProdAuftrag

                        bap_banr || COALESCE(' > '||bap_agnr, '') AS descr,
                        bap_id,
                        bap_parent_id AS bapparentid, --zur Ermittlung des Bestands zum Datum der Bestellanforderungspos
                        bap_txt AS parentaknrmenge

                  FROM  BestAnfPos JOIN BestAnfTxt ON bap_banr=ba_nr
                                   --JOIN art ON ak_nr=bap_aknr
                  WHERE bap_aknr=aknr
                    AND NOT bap_done
                    AND (NOT (bap_termin IS NULL AND bap_termweek IS NULL)
                         AND (   date_to_yearmonth(
                                    coalesce(
                                        bap_termin,
                                        termweek_to_date(bap_termweek)
                                    )
                                 ) >= date_to_yearmonth(today())
                              OR bap_pr_ag_id IS NOT NULL
                              OR bap_pr_ld_id IS NOT NULL
                              ) /*nur im Zusammenhang mit NOT bap_done, letzten beiden OR: definitivprognose im Rückstand*/
                         )
                    AND bap_menge<>0
                    AND bap_doeinkauf
                    AND ba_prognose --Bestellanforderungen ohne Prognosen, diese errechnen sich auf Monatszyklus-eben als nächstes
                    AND bap_pos>=0 --- => wenn kleiner 0 => Prognose aus Auftrag/Bestellung, da ist dann der Artikel selbst durch die Position bereits in der Bedarf und muß nicht noch einmal pronostiziert werden
                  --GROUP BY
                  --  1 /*date*/, 2/*dateym*/, ptyp, bap_aknr --, ak_bfr --, bap_termin --, bap_menge, bap_menge_uf1
                  ORDER BY
                    date, bap_banr, bap_agnr, menge DESC) LOOP
          result:=r;
          pos:=pos+1;
          result.pos:=pos;

          result.descr:=CAST(result.descr AS VARCHAR(100));
          --Auskommentiert: Prognosen werden durch Aufträge abggelöst
          --IF lastmonth IS DISTINCT FROM date_to_yearmonth(r.date) /*wenn in einem Monat mehrere Datensätze nicht für jeden die gleichen Verbraushzahlen holen!, es wird so nur der höchste ausgegeben*/
          --   THEN
          --      SELECT SUM(ag_stk_uf1) INTO result.mengeauftg FROM auftg WHERE ag_aknr=aknr AND (date_to_yearmonth(COALESCE(ag_ldatum, ag_kdatum))=date_to_yearmonth(r.date) OR (date_to_yearmonth(today())=date_to_yearmonth(r.date) AND not ag_done AND COALESCE(ag_ldatum, ag_kdatum) ISNULL));--Laufenden Bedarfe -- ohne Termin wird in den aktuellen Monat eingerechnet!
          --END IF;
          --
          result.bewegung:=-result.menge+COALESCE(result.mengeauftg,0);--wir errechnen, was an Prognosen noch nicht aufgelegt wurde, das muß noch aufgelegt werden
          IF debugmessages THEN
                RAISE NOTICE 'INITIAL!Aknr=%;bewegung=%;Menge=%;MengeA=%', aknr, result.bewegung, result.menge, result.mengeauftg;
          END IF;
          --wir prüfen, ob ein Oberartikel des aktuellen Artikels lagernd ist, dann muß der aktuelle Artikel ja nicht mehr hergestellt werden
          --dazu gehen wir über diee parents und schauen, ob die bedarfssumme < bestand zum bedarfsdatum ist!
          --wir schauen nur direkt die ebene darüber, da diese selbst ja ihre oberebene bereits betrachtet hat!
          IF result.parentaknrmenge IS NOT NULL THEN
                --durch das nächste Statement gehen wir immer genau eine Ebene höher (ebene/splitpart3=0)
                FOR r1 IN SELECT split_part(unnest, ':', 1) AS aknr, SUM(split_part(unnest, ':', 2)::NUMERIC(19,6)) AS menge FROM unnest(string_to_array(result.parentaknrmenge, ',')) WHERE split_part(unnest, ':', 3)=0 GROUP BY aknr ORDER BY 1 LOOP
                    IF result.bewegung<>0 THEN --ansonsten gab es bereits einen SKIP (parent ist ausreichend vorhanden)
                   --wir holen uns, was unser direkter parent eigentlich an bewegungsmenge wollte und wieviel er tatsächlich hat
                SELECT bap_id, bap_pr_ag_id, bap_pos<=0, bap_menge INTO bapid, bapagid, bapposisparent, bapmenge FROM bestanfpos WHERE bap_aknr=r1.aknr AND bap_parent_id=r.bapparentid; --kopfdatensatz ist in der Gruppe sich selbst zugewiesen (-1, 0 Position?)
                IF bapposisparent THEN --der Hauptdatensatz der BANF löst ja selbst keinen Bedarf aus, dafür gibt es bereits den Verkaufsauftrag. Daher in dem Fall über die agid auf bedarf
                  SELECT b_bestand, b_nbestand, b_zuab, b_zuab/bapmenge INTO vbestand, datumbestand, vbzuab, vprozmenge FROM bedarf WHERE b_ag_id=bapagid;
                ELSE
                  SELECT b_bestand, b_nbestand, b_zuab, b_zuab/bapmenge INTO vbestand, datumbestand, vbzuab, vprozmenge FROM bedarf WHERE b_bap_id=bapid;
                END IF;
                        --datumbestand:=tartikel.bedarf__getbestand(r1.aknr, r.date); --timediff_adddays(r.date, akbfr, true)::DATE);
                        IF debugmessages THEN
                                RAISE NOTICE 'BEGIN!!!!!!!Aknr=%; bewegung=% ParentMenge=% VBestandBapId=% DatumBestand=% vbzuab=%, vprozmenge=%, date=%, bapparentid=%, ', r1.aknr, result.bewegung, r1.menge, vbestand, datumbestand, vbzuab, vprozmenge, r.date, r.bapparentid;
                        END IF;
                        If datumbestand>=0 THEN
                                IF debugmessages THEN
                                        RAISE NOTICE '!!!!!!!Parent is VERFUEG, SKIP';
                                END IF;
                                --kopfartikel ausreichend vorhanden, diese Menge brauchen wir also nicht. evtl haben wir aber noch mehr Bedarfe dieses Artikels summiert!
                                result.bewegung:=result.bewegung+r1.menge; --menge meiner Position in der BANF, Summiert. Im Array stehen evtl mehrere Auslöser, daher hier diesen einen Auslöser wegaddieren
                                --dazu rechnen wir raus, was eigentlich an bedarf angezeigt wurde und nehmen den negativbedarf hinzu!
                        ELSE
                        -- der Kopfartikel selbst ist nicht vollständig verfügbar.
                         -- Fall1: er ist überhauptnicht verügbar, wir müßten einfach genau in der Menge ausgelöst werden, wie es in der Liste steht.
                         -- Fall2: Kopf ist zum Teil verfügbar, zB durch Lagerbestand
                         -- > wir nehmen im Fall, das eine Positive Menge als Altbestand war, diese Menge als Verwendbar an
                                 IF debugmessages THEN
                                        RAISE NOTICE '!!!!!!!Parent is PARTIAL';
                                 END IF;
                                 result.bewegung:=IFTHEN(vbestand>0, vbestand, 0)+result.bewegung*ABS(vprozmenge); --TODO: Verhältnis einbauen. Wenn 2 Kopf und 4 Unterbauteile, dann muß bei 1 Kopf verfügbar nur 2 Unterbauteile rausgestrichen werden
                                 --result.bewegung:=result.bewegung-vbzuab;
                        END IF;
                        IF debugmessages THEN
                                RAISE NOTICE '!!!!!!!Aknr=%; bewegung=% ParentMenge=% BestandBapId=% (%)', r1.aknr, result.bewegung, r1.menge, datumbestand, r.date;
                        END IF;
                    END IF;
                END LOOP;
                IF debugmessages THEN
                  RAISE NOTICE 'XXXXXXXXXXXXXXXXXXXXXXX Bewegung %', result.bewegung;
                END IF;
          END IF;
          --lastauftgmenge:=(SUM(ag_stk_uf1) FROM auftg WHERE ag_aknr=a.bap_aknr AND NOT ag_done AND (date_to_yearmonth(COALESCE(ag_ldatum, ag_kdatum))=a.date OR (a.date=date_to_yearmonth(current_date) AND date_to_yearmonth(COALESCE(ag_ldatum, ag_kdatum))<a.date)))
          --IF debug/*für Debugausgabe (alles) True/False switchen*/ OR lastmonth IS DISTINCT FROM date_to_yearmonth(r.date) THEN--wir geben immer nur den höchsten Bedarf der Prognosen des Monats zurück, dies wird durch das OrderBy MENGE DESC bereits erreicht
          --      lastmonth:=date_to_yearmonth(r.date);--Folgemonat: immer nur den höchsten Bedarf zurückgeben
          --      IF debug OR result.bewegung<0 THEN
          --              RETURN NEXT result;
          --      END IF;
          --END IF;
          --
          IF result.bewegung<0 THEN
                RETURN NEXT result;
          END IF;
         END LOOP;
         RETURN;
        END $$ LANGUAGE plpgsql;

    -- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
--

-- SONSTIGES

 ----Holt Maschinenbezeichnung für KS aus ks_babz bis ks_babz9 (ks hat Format 'ks_abt/1 .. ks_abt/10'
 CREATE OR REPLACE FUNCTION tplanterm.ksv__ks_babz__from__PT_KS_BEZ(ks VARCHAR) RETURNS VARCHAR AS $$
  DECLARE maschname VARCHAR;
          nr        VARCHAR;
          I         INTEGER;
  BEGIN
    IF NOT ks LIKE '%|0' THEN--nicht die Pool
      nr:='ks_babz';
      FOR I IN 2..10 LOOP
          IF ks LIKE '%/'||I THEN --wenn CNC /1 wie %/1 dann - gefunden
                  nr:='ks_babz' || I-1;
          END IF;--ks /1 = babz;;; ks /2 = babz1
          --RAISE EXCEPTION '%', ks;
          EXECUTE ('SELECT ' || nr || ' FROM ksv WHERE ' || quote_literal(ks) || ' LIKE (ks_abt||''%'')') INTO maschname; --Statement bauen und abfragen
      END LOOP;
      RETURN maschname;
    ELSE
      RETURN 'Pool';
    END IF;
  END $$ LANGUAGE plpgsql STABLE;

 CREATE OR REPLACE FUNCTION Z_99_Deprecated.maschbez(ks VARCHAR) RETURNS VARCHAR AS $$
   SELECT tplanterm.ksv__ks_babz__from__PT_KS_BEZ(ks);
   $$ LANGUAGE sql;
--

-- returns array of available ksaps from the given ksv name
CREATE OR REPLACE FUNCTION tplanterm.ksv__ksaps__fetch( _abt_name varchar ) RETURNS varchar[] AS $$
    DECLARE row RECORD;
    BEGIN
      SELECT * FROM ksv INTO row WHERE ks_abt = _abt_name LIMIT 1;
      RETURN array_remove(
        array[row.ks_babz,row.ks_babz1, row.ks_babz2,row.ks_babz3,row.ks_babz4,row.ks_babz5,row.ks_babz6,row.ks_babz7,row.ks_babz8,row.ks_babz9],
        NULL
      );

    END $$ LANGUAGE plpgsql;

--
